/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.compat.pneumaticcraft;

import ad_astra_giselle_addon.common.compat.pneumaticcraft.AddonCommonUpgradeHandlers;
import ad_astra_giselle_addon.common.compat.pneumaticcraft.AddonPneumaticCraftConfig;
import ad_astra_giselle_addon.common.compat.pneumaticcraft.pneumatic_armor.handlers.GravityProofCommonHandler;
import ad_astra_giselle_addon.common.compat.pneumaticcraft.pneumatic_armor.handlers.HotTemperatureProofCommonHandler;
import ad_astra_giselle_addon.common.compat.pneumaticcraft.pneumatic_armor.handlers.OxygenProofCommonHandler;
import ad_astra_giselle_addon.common.compat.pneumaticcraft.pneumatic_armor.handlers.VenusAcidProofCommonHandler;
import ad_astra_giselle_addon.common.content.oxygen.IOxygenCharger;
import ad_astra_giselle_addon.common.content.oxygen.OxygenChargerUtils;
import ad_astra_giselle_addon.common.content.proof.ProofAbstractUtils;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.fluid.FluidPredicates;
import ad_astra_giselle_addon.common.fluid.UniveralFluidHandler;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class PneumaticCraftProofProvidingHandler {
    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent e) {
        long oxygenUsing;
        int airUsing;
        OxygenProofCommonHandler upgradeHandler;
        int airDuration;
        LivingEntity living = e.getEntity();
        if (living.m_9236_().m_5776_()) {
            return;
        }
        int airSupply = living.m_20146_();
        int maxAirSupply = living.m_6062_();
        if (maxAirSupply - airSupply >= (airDuration = 30) && this.useAirAndOxygen(living, upgradeHandler = AddonCommonUpgradeHandlers.OXYGEN_PROOF, airUsing = AddonPneumaticCraftConfig.OXYGEN_PROOF_AIR_USING, oxygenUsing = ProofAbstractUtils.OXYGEN_PROOF_USING, false)) {
            living.m_20301_(airSupply + airDuration);
        }
    }

    public int onOxygenProof(LivingEntity living) {
        OxygenProofCommonHandler upgradeHandler = AddonCommonUpgradeHandlers.OXYGEN_PROOF;
        int airUsing = AddonPneumaticCraftConfig.OXYGEN_PROOF_AIR_USING;
        long oxygenUsing = ProofAbstractUtils.OXYGEN_PROOF_USING;
        return this.useAirAndOxygen(living, upgradeHandler, airUsing, oxygenUsing, false) ? 30 : 0;
    }

    public int onHotTemperatureProof(LivingEntity living) {
        HotTemperatureProofCommonHandler upgradeHandler = AddonCommonUpgradeHandlers.HOT_TEMPERATURE_PROOF;
        int airUsing = AddonPneumaticCraftConfig.HOT_TEMPERATURE_PROOF_AIR_USING;
        return this.useAir(living, (IArmorUpgradeHandler<?>)upgradeHandler, airUsing, false) ? 10 : 0;
    }

    public int onAcidRainProof(LivingEntity living) {
        VenusAcidProofCommonHandler upgradeHandler = AddonCommonUpgradeHandlers.ACID_RAIN_PROOF;
        int airUsing = AddonPneumaticCraftConfig.ACID_RAIN_PROOF_AIR_USING;
        return this.useAir(living, (IArmorUpgradeHandler<?>)upgradeHandler, airUsing, false) ? 10 : 0;
    }

    public int onGravityProof(LivingEntity living) {
        GravityProofCommonHandler upgradeHandler = AddonCommonUpgradeHandlers.GRAVITY_PROOF;
        int airUsing = AddonPneumaticCraftConfig.GRAVITY_PROOF_AIR_USING;
        return this.useAir(living, (IArmorUpgradeHandler<?>)upgradeHandler, airUsing, false) ? 10 : 0;
    }

    public boolean useAirAndOxygen(LivingEntity living, OxygenProofCommonHandler upgradeHandler, int airUsing, long oxygenUsing, boolean simulate) {
        if (this.useAir(living, (IArmorUpgradeHandler<?>)upgradeHandler, airUsing, true)) {
            if (LivingHelper.isPlayingMode(living)) {
                IOxygenCharger oxygenCharger = OxygenChargerUtils.firstExtractable(living, oxygenUsing);
                if (oxygenCharger != null) {
                    if (!simulate) {
                        this.useAir(living, (IArmorUpgradeHandler<?>)upgradeHandler, airUsing, false);
                        UniveralFluidHandler fluidHandler = oxygenCharger.getFluidHandler();
                        FluidHooks2.extractFluid(fluidHandler, FluidPredicates::isOxygen, oxygenUsing, false);
                    }
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean useAir(LivingEntity living, IArmorUpgradeHandler<?> upgradeHandler, int airUsing, boolean simulate) {
        ItemStack stack = PneumaticCraftProofProvidingHandler.getUpgradeUsablePneumaticArmorItem(living, upgradeHandler);
        if (stack.m_41619_()) {
            return false;
        }
        IAirHandlerItem airHandler = (IAirHandlerItem)stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).orElse(null);
        return airHandler != null && this.useAir(living, airHandler, airUsing, simulate);
    }

    @NotNull
    public static ItemStack getUpgradeUsablePneumaticArmorItem(LivingEntity living, IArmorUpgradeHandler<?> upgradeHandler) {
        if (living instanceof Player) {
            Player player = (Player)living;
            CommonArmorHandler commonHandler = CommonArmorHandler.getHandlerForPlayer((Player)player);
            ItemStack stack = living.m_6844_(upgradeHandler.getEquipmentSlot());
            if (commonHandler.upgradeUsable(upgradeHandler, true) && stack.m_41720_() instanceof PneumaticArmorItem) {
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean useAir(LivingEntity living, IAirHandlerItem airHandler, int airUsing, boolean simulate) {
        return !LivingHelper.isPlayingMode(living) || this.useAir((IAirHandler)airHandler, airUsing, simulate);
    }

    public boolean useAir(IAirHandler airHandler, int airUsing, boolean simulate) {
        if (airHandler.getAir() >= airUsing) {
            if (!simulate) {
                airHandler.addAir(-airUsing);
            }
            return true;
        }
        return false;
    }
}

