/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.proof;

import ad_astra_giselle_addon.common.content.proof.ProofFunction;
import ad_astra_giselle_addon.common.enchantment.EnchantmentHelper2;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.ItemUsableResource;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public abstract class ProofEnchantmentFunction
implements ProofFunction {
    @Override
    public int provide(LivingEntity living) {
        @NotNull Pair<EquipmentSlot, Integer> pair = EnchantmentHelper2.getEnchantmentItemAndLevel(this.getEnchantment(), living);
        EquipmentSlot slot = (EquipmentSlot)pair.getFirst();
        int enchantLevel = (Integer)pair.getSecond();
        if (slot == null || enchantLevel == 0) {
            return 0;
        }
        if (LivingHelper.isPlayingMode(living)) {
            ItemStackReference enchantedItem = LivingHelper.getEquipmentItem(living, slot);
            ItemUsableResource resource = ItemUsableResource.first(enchantedItem.getStack());
            if (resource != null && this.consume(living, slot, enchantedItem, resource, true)) {
                this.consume(living, slot, enchantedItem, resource, false);
                return this.getProofDuration(resource);
            }
            return 0;
        }
        return 10;
    }

    public boolean consume(LivingEntity living, EquipmentSlot slot, ItemStackReference enchantedItem, ItemUsableResource resource, boolean simulate) {
        long extracting = this.getResourceUsingAmount(resource);
        long extracted = resource.extract(living, slot, enchantedItem, extracting, simulate);
        return extracted >= extracting;
    }

    public abstract Enchantment getEnchantment();

    public abstract long getResourceUsingAmount(ItemUsableResource var1);

    public abstract int getProofDuration(ItemUsableResource var1);
}

