/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crossroads.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class OreCleanserRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object output;
    public final int count;

    public OreCleanserRecipeSerializer(ResourceLocation key, Object input, Object output, int count) {
        this(key, "", input, output, count);
    }

    public OreCleanserRecipeSerializer(ResourceLocation key, String group, Object input, Object output, int count) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.count = count;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "crossroads:ore_cleanser");
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        json.add("ingredient", ing.m_43942_());
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        return json;
    }
}

