/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.energizedpower.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class PulverizerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final double[] chances;
    public final double[] chancesAdvanced;
    public final Object secondOutput;
    public final double[] secondChances;
    public final double[] secondChancesAdvanced;

    public PulverizerRecipeSerializer(ResourceLocation key, Object input, Object output, double[] chances, double[] chancesAdvanced) {
        this(key, input, output, chances, chancesAdvanced, ItemStack.f_41583_, new double[0], new double[0]);
    }

    public PulverizerRecipeSerializer(ResourceLocation key, Object input, Object output, double[] chances, double[] chancesAdvanced, Object secondOutput, double[] secondChances, double[] secondChancesAdvanced) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.chances = chances;
        this.chancesAdvanced = chancesAdvanced;
        this.secondOutput = secondOutput;
        this.secondChances = secondChances;
        this.secondChancesAdvanced = secondChancesAdvanced;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, 1);
        if (stack.m_41619_() || this.chances.length == 0) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, 1);
        JsonObject json = new JsonObject();
        json.addProperty("type", "energizedpower:pulverizer");
        json.add("ingredient", ing.m_43942_());
        JsonObject outputJson = new JsonObject();
        outputJson.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        JsonArray outputChanceJson = new JsonArray();
        for (double chance : this.chances) {
            outputChanceJson.add((Number)chance);
        }
        outputJson.add("percentages", (JsonElement)outputChanceJson);
        JsonArray outputChanceAdvancedJson = new JsonArray();
        for (double chance : this.chancesAdvanced) {
            outputChanceAdvancedJson.add((Number)chance);
        }
        outputJson.add("percentagesAdvanced", (JsonElement)outputChanceAdvancedJson);
        json.add("output", (JsonElement)outputJson);
        if (!secondStack.m_41619_() && this.secondChances.length != 0) {
            JsonObject secondOutputJson = new JsonObject();
            secondOutputJson.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(secondStack));
            JsonArray secondOutputChanceJson = new JsonArray();
            for (double chance : this.secondChances) {
                secondOutputChanceJson.add((Number)chance);
            }
            secondOutputJson.add("percentages", (JsonElement)secondOutputChanceJson);
            JsonArray secondOutputChanceAdvancedJson = new JsonArray();
            for (double chance : this.secondChancesAdvanced) {
                secondOutputChanceAdvancedJson.add((Number)chance);
            }
            secondOutputJson.add("percentagesAdvanced", (JsonElement)secondOutputChanceAdvancedJson);
            json.add("secondaryOutput", (JsonElement)secondOutputJson);
        }
        return json;
    }
}

