/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering.recipes;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class CrusherRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;
    public final int energy;

    public CrusherRecipeSerializer(ResourceLocation key, Object input, Object[] output, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.energy = energy;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        IngredientWithSize result = null;
        ArrayList<Pair> secondary = new ArrayList<Pair>();
        int i = 0;
        while (i < this.output.length) {
            Ingredient is;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((is = MiscHelper.INSTANCE.getIngredient(out)) == EmptyIngredient.INSTANCE) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            if (result == null) {
                result = new IngredientWithSize(is, count.intValue());
                continue;
            }
            secondary.add(Pair.of((Object)new IngredientWithSize(is, count.intValue()), (Object)chance));
        }
        if (result == null) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "immersiveengineering:crusher");
        json.add("input", ing.m_43942_());
        json.add("result", result.serialize());
        JsonArray secondaryJson = new JsonArray();
        for (Pair pair : secondary) {
            JsonObject outputJson = new JsonObject();
            outputJson.add("output", ((IngredientWithSize)pair.getLeft()).serialize());
            outputJson.addProperty("chance", (Number)pair.getRight());
            secondaryJson.add((JsonElement)outputJson);
        }
        json.add("secondaries", (JsonElement)secondaryJson);
        json.addProperty("energy", (Number)this.energy);
        return json;
    }
}

