/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.nuclearcraft.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.NuclearCraftHelper;
import thelm.jaopca.utils.MiscHelper;

public class CentrifugeRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputAmount;
    public final Object[] output;
    public final double radiation;
    public final double time;
    public final double power;

    public CentrifugeRecipeSerializer(ResourceLocation key, Object input, int inputAmount, Object[] output, double radiation, double time, double power) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.radiation = radiation;
        this.time = time;
        this.power = power;
    }

    @Override
    public JsonElement get() {
        FluidStackIngredient ing = NuclearCraftHelper.INSTANCE.getFluidStackIngredient(this.input, this.inputAmount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<FluidStack> outputs = new ArrayList<FluidStack>();
        int i = 0;
        while (i < this.output.length) {
            FluidStack stack;
            Object out = this.output[i];
            Integer amount = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                amount = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getFluidStack(out, amount)).isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(stack);
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "nuclearcraft:centrifuge");
        JsonArray inputJson = new JsonArray();
        inputJson.add(ing.serialize());
        json.add("inputFluids", (JsonElement)inputJson);
        JsonArray outputJson = new JsonArray();
        for (FluidStack stack : outputs) {
            outputJson.add((JsonElement)MiscHelper.INSTANCE.serializeFluidStack(stack));
        }
        json.add("outputFluids", (JsonElement)outputJson);
        json.addProperty("radiation", (Number)this.radiation);
        json.addProperty("timeModifier", (Number)this.time);
        json.addProperty("powerModifier", (Number)this.power);
        return json;
    }
}

