/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.nuclearcraft.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.NuclearCraftHelper;
import thelm.jaopca.utils.MiscHelper;

public class CrystallizerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputCount;
    public final double radiation;
    public final double time;
    public final double power;

    public CrystallizerRecipeSerializer(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, double radiation, double time, double power) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.radiation = radiation;
        this.time = time;
        this.power = power;
    }

    @Override
    public JsonElement get() {
        FluidStackIngredient ing = NuclearCraftHelper.INSTANCE.getFluidStackIngredient(this.input, this.inputAmount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "nuclearcraft:crystallizer");
        JsonArray inputJson = new JsonArray();
        inputJson.add(ing.serialize());
        json.add("inputFluids", (JsonElement)inputJson);
        JsonArray outputJson = new JsonArray();
        outputJson.add((JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.add("output", (JsonElement)outputJson);
        json.addProperty("radiation", (Number)this.radiation);
        json.addProperty("timeModifier", (Number)this.time);
        json.addProperty("powerModifier", (Number)this.power);
        return json;
    }
}

