/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.nuclearcraft.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import igentuman.nc.recipes.ingredient.FluidStackIngredient;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.nuclearcraft.NuclearCraftHelper;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class LeacherRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object output;
    public final int outputAmount;
    public final double radiation;
    public final double time;
    public final double power;

    public LeacherRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputAmount, double radiation, double time, double power) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.outputAmount = outputAmount;
        this.radiation = radiation;
        this.time = time;
        this.power = power;
    }

    @Override
    public JsonElement get() {
        Ingredient itemIng = MiscHelper.INSTANCE.getIngredient(this.itemInput);
        if (itemIng == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
        }
        FluidStackIngredient fluidIng = NuclearCraftHelper.INSTANCE.getFluidStackIngredient(this.fluidInput, this.fluidInputAmount);
        if (fluidIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.fluidInput);
        }
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "nuclearcraft:leacher");
        JsonArray itemInputJson = new JsonArray();
        JsonObject itemIngJson = MiscHelper.INSTANCE.wrapIngredient(itemIng).m_43942_().getAsJsonObject();
        itemIngJson.addProperty("count", (Number)this.itemInputCount);
        itemInputJson.add((JsonElement)itemIngJson);
        json.add("input", (JsonElement)itemInputJson);
        JsonArray fluidInputJson = new JsonArray();
        fluidInputJson.add(fluidIng.serialize());
        json.add("inputFluids", (JsonElement)fluidInputJson);
        JsonArray outputJson = new JsonArray();
        outputJson.add((JsonElement)MiscHelper.INSTANCE.serializeFluidStack(stack));
        json.add("outputFluids", (JsonElement)outputJson);
        json.addProperty("radiation", (Number)this.radiation);
        json.addProperty("timeModifier", (Number)this.time);
        json.addProperty("powerModifier", (Number)this.power);
        return json;
    }
}

