/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.tconstruct.TConstructHelper;
import thelm.jaopca.utils.MiscHelper;

public class CastingTableRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object cast;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputCount;
    public final ToIntFunction<FluidStack> time;
    public final boolean consumeCast;
    public final boolean switchSlots;

    public CastingTableRecipeSerializer(ResourceLocation key, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        this(key, "", cast, input, inputAmount, output, outputCount, time, consumeCast, switchSlots);
    }

    public CastingTableRecipeSerializer(ResourceLocation key, String group, Object cast, Object input, int inputAmount, Object output, int outputCount, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.cast = cast;
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
        this.consumeCast = consumeCast;
        this.switchSlots = switchSlots;
    }

    @Override
    public JsonElement get() {
        FluidIngredient fluidIng = TConstructHelper.INSTANCE.getFluidIngredient(this.input, this.inputAmount);
        if (fluidIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        FluidStack funcStack = MiscHelper.INSTANCE.getFluidStack(this.input, this.inputAmount);
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.cast);
        ItemOutput out = TConstructHelper.INSTANCE.getItemOutput(this.output, this.outputCount);
        if (out == null) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "tconstruct:casting_table");
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        json.add("fluid", fluidIng.serialize());
        if (!ing.m_43947_()) {
            json.add("cast", ing.m_43942_());
            json.addProperty("cast_consumed", Boolean.valueOf(this.consumeCast));
        }
        json.add("result", out.serialize(true));
        json.addProperty("cooling_time", (Number)this.time.applyAsInt(funcStack));
        json.addProperty("switch_slots", Boolean.valueOf(this.switchSlots));
        return json;
    }
}

