/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Tables;
import com.google.common.collect.TreeBasedTable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IFluidFormType;
import thelm.jaopca.api.fluids.IFluidInfo;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.fluids.IMaterialFormFluidType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.custom.json.FluidFormSettingsDeserializer;
import thelm.jaopca.custom.json.ForgeRegistryEntrySupplierDeserializer;
import thelm.jaopca.data.DataInjector;
import thelm.jaopca.fluids.FluidFormSettings;
import thelm.jaopca.fluids.FluidInfo;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.registries.RegistryHandler;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class FluidFormType
implements IFluidFormType {
    public static final FluidFormType INSTANCE = new FluidFormType();
    private static final TreeSet<IForm> FORMS = new TreeSet();
    private static final TreeBasedTable<IForm, IMaterial, java.util.function.Supplier<IMaterialFormFluid>> FLUIDS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, java.util.function.Supplier<IMaterialFormFluidType>> FLUID_TYPES = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, java.util.function.Supplier<IMaterialFormFluidBlock>> FLUID_BLOCKS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, java.util.function.Supplier<IMaterialFormBucketItem>> BUCKET_ITEMS = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, IFluidInfo> FLUID_INFOS = TreeBasedTable.create();
    private static boolean registered = false;
    public static final Type SOUND_EVENT_SUPPLIER_TYPE = new TypeToken<java.util.function.Supplier<SoundEvent>>(){}.getType();

    private FluidFormType() {
    }

    public static void init() {
        FormTypeHandler.registerFormType(INSTANCE);
    }

    @Override
    public String getName() {
        return "fluid";
    }

    @Override
    public void addForm(IForm form) {
        FORMS.add(form);
    }

    @Override
    public Set<IForm> getForms() {
        return Collections.unmodifiableNavigableSet(FORMS);
    }

    @Override
    public boolean shouldRegister(IForm form, IMaterial material) {
        ResourceLocation tagLocation = MiscHelper.INSTANCE.getTagLocation(form.getSecondaryName(), material.getName(), form.getTagSeparator());
        return !ApiImpl.INSTANCE.getFluidTags().contains(tagLocation);
    }

    @Override
    public IFluidInfo getMaterialFormInfo(IForm form, IMaterial material) {
        IFluidInfo info = (IFluidInfo)FLUID_INFOS.get((Object)form, (Object)material);
        if (info == null && FORMS.contains(form) && form.getMaterials().contains(material)) {
            info = new FluidInfo((IMaterialFormFluid)((java.util.function.Supplier)FLUIDS.get((Object)form, (Object)material)).get(), (IMaterialFormFluidType)((java.util.function.Supplier)FLUID_TYPES.get((Object)form, (Object)material)).get(), (IMaterialFormFluidBlock)((java.util.function.Supplier)FLUID_BLOCKS.get((Object)form, (Object)material)).get(), (IMaterialFormBucketItem)((java.util.function.Supplier)BUCKET_ITEMS.get((Object)form, (Object)material)).get());
            FLUID_INFOS.put((Object)form, (Object)material, (Object)info);
        }
        return info;
    }

    @Override
    public IFluidFormSettings getNewSettings() {
        return new FluidFormSettings();
    }

    public IFluidFormSettings getNewSettingsLava() {
        return new FluidFormSettings().setTickRateFunction(material -> 30).setDensityFunction(material -> 2000).setTemperatureFunction(material -> 1000).setFillSoundSupplier(() -> SoundEvents.f_11783_).setEmptySoundSupplier(() -> SoundEvents.f_11780_).setMotionScaleFunction(material -> 0.0023333333333333335).setCanDrownFunction(material -> false).setPathTypeFunction(material -> BlockPathTypes.LAVA).setAdjacentPathTypeFunction(material -> null).setMaterialFunction(material -> Material.f_76307_).setFireTimeFunction(material -> 15);
    }

    @Override
    public GsonBuilder configureGsonBuilder(GsonBuilder builder) {
        return builder.registerTypeAdapter(SOUND_EVENT_SUPPLIER_TYPE, (Object)ForgeRegistryEntrySupplierDeserializer.INSTANCE);
    }

    @Override
    public IFluidFormSettings deserializeSettings(JsonElement jsonElement, JsonDeserializationContext context) {
        return FluidFormSettingsDeserializer.INSTANCE.deserialize(jsonElement, context);
    }

    @Override
    public void registerMaterialForms() {
        if (registered) {
            return;
        }
        registered = true;
        MiscHelper helper = MiscHelper.INSTANCE;
        for (IForm form : FORMS) {
            IFluidFormSettings settings = (IFluidFormSettings)form.getSettings();
            String secondaryName = form.getSecondaryName();
            String tagSeparator = form.getTagSeparator();
            for (IMaterial material : form.getMaterials()) {
                String name = form.getName() + "." + material.getName();
                ResourceLocation registryName = new ResourceLocation("jaopca", name);
                Supplier materialFormFluid = Suppliers.memoize(() -> settings.getFluidCreator().create(form, material, settings));
                FLUIDS.put((Object)form, (Object)material, (Object)materialFormFluid);
                RegistryHandler.registerForgeRegistryEntry(Registry.f_122899_, name, () -> FluidFormType.lambda$registerMaterialForms$12((java.util.function.Supplier)materialFormFluid));
                Supplier materialFormFluidType = Suppliers.memoize(() -> FluidFormType.lambda$registerMaterialForms$13(settings, (java.util.function.Supplier)materialFormFluid));
                FLUID_TYPES.put((Object)form, (Object)material, (Object)materialFormFluidType);
                RegistryHandler.registerForgeRegistryEntry(ForgeRegistries.Keys.FLUID_TYPES, name, () -> FluidFormType.lambda$registerMaterialForms$14((java.util.function.Supplier)materialFormFluidType));
                Supplier materialFormFluidBlock = Suppliers.memoize(() -> FluidFormType.lambda$registerMaterialForms$15(settings, (java.util.function.Supplier)materialFormFluid));
                FLUID_BLOCKS.put((Object)form, (Object)material, (Object)materialFormFluidBlock);
                RegistryHandler.registerForgeRegistryEntry(Registry.f_122901_, name, () -> FluidFormType.lambda$registerMaterialForms$16((java.util.function.Supplier)materialFormFluidBlock));
                Supplier materialFormBucketItem = Suppliers.memoize(() -> FluidFormType.lambda$registerMaterialForms$17(settings, (java.util.function.Supplier)materialFormFluid));
                BUCKET_ITEMS.put((Object)form, (Object)material, (Object)materialFormBucketItem);
                RegistryHandler.registerForgeRegistryEntry(Registry.f_122904_, name, () -> FluidFormType.lambda$registerMaterialForms$18((java.util.function.Supplier)materialFormBucketItem));
                DataInjector.registerFluidTag(helper.createResourceLocation(secondaryName), registryName);
                DataInjector.registerFluidTag(helper.getTagLocation(secondaryName, material.getName(), tagSeparator), registryName);
                for (String alternativeName : material.getAlternativeNames()) {
                    DataInjector.registerFluidTag(helper.getTagLocation(secondaryName, alternativeName, tagSeparator), registryName);
                }
            }
        }
    }

    public static Collection<IMaterialFormFluid> getFluids() {
        return Tables.transformValues(FLUIDS, java.util.function.Supplier::get).values();
    }

    public static Collection<IMaterialFormFluidType> getFluidTypes() {
        return Tables.transformValues(FLUID_TYPES, java.util.function.Supplier::get).values();
    }

    public static Collection<IMaterialFormFluidBlock> getFluidBlocks() {
        return Tables.transformValues(FLUID_BLOCKS, java.util.function.Supplier::get).values();
    }

    public static Collection<IMaterialFormBucketItem> getBucketItems() {
        return Tables.transformValues(BUCKET_ITEMS, java.util.function.Supplier::get).values();
    }

    private static /* synthetic */ Item lambda$registerMaterialForms$18(java.util.function.Supplier materialFormBucketItem) {
        return ((IMaterialFormBucketItem)materialFormBucketItem.get()).toItem();
    }

    private static /* synthetic */ IMaterialFormBucketItem lambda$registerMaterialForms$17(IFluidFormSettings settings, java.util.function.Supplier materialFormFluid) {
        return settings.getBucketItemCreator().create((IMaterialFormFluid)materialFormFluid.get(), settings);
    }

    private static /* synthetic */ Block lambda$registerMaterialForms$16(java.util.function.Supplier materialFormFluidBlock) {
        return ((IMaterialFormFluidBlock)materialFormFluidBlock.get()).toBlock();
    }

    private static /* synthetic */ IMaterialFormFluidBlock lambda$registerMaterialForms$15(IFluidFormSettings settings, java.util.function.Supplier materialFormFluid) {
        return settings.getFluidBlockCreator().create((IMaterialFormFluid)materialFormFluid.get(), settings);
    }

    private static /* synthetic */ FluidType lambda$registerMaterialForms$14(java.util.function.Supplier materialFormFluidType) {
        return ((IMaterialFormFluidType)materialFormFluidType.get()).toFluidType();
    }

    private static /* synthetic */ IMaterialFormFluidType lambda$registerMaterialForms$13(IFluidFormSettings settings, java.util.function.Supplier materialFormFluid) {
        return settings.getFluidTypeCreator().create((IMaterialFormFluid)materialFormFluid.get(), settings);
    }

    private static /* synthetic */ Fluid lambda$registerMaterialForms$12(java.util.function.Supplier materialFormFluid) {
        return ((IMaterialFormFluid)materialFormFluid.get()).toFluid();
    }
}

