/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.fluids.PlaceableFluid;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;

public class JAOPCAFluidBlock
extends PlaceableFluidBlock
implements IMaterialFormFluidBlock {
    private final IMaterialFormFluid fluid;
    protected final IFluidFormSettings settings;
    protected Optional<Material> blockMaterial = Optional.empty();
    protected Optional<MaterialColor> materialColor = Optional.empty();
    protected OptionalInt lightValue = OptionalInt.empty();
    protected OptionalDouble explosionResistance = OptionalDouble.empty();
    protected OptionalInt flammability = OptionalInt.empty();
    protected OptionalInt fireSpreadSpeed = OptionalInt.empty();
    protected Optional<Boolean> isFireSource = Optional.empty();
    protected OptionalInt fireTime = OptionalInt.empty();

    public JAOPCAFluidBlock(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(BlockBehaviour.Properties.m_60944_((Material)settings.getMaterialFunction().apply(fluid.getMaterial()), (MaterialColor)settings.getMaterialColorFunction().apply(fluid.getMaterial())).m_60978_((float)settings.getBlockHardnessFunction().applyAsDouble(fluid.getMaterial())).m_60953_(state -> settings.getLightValueFunction().applyAsInt(fluid.getMaterial())).m_60910_().m_60977_().m_222994_().m_60955_(), (PlaceableFluid)fluid.toFluid(), settings.getMaxLevelFunction().applyAsInt(fluid.getMaterial()));
        this.fluid = fluid;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        if (!this.lightValue.isPresent()) {
            this.lightValue = OptionalInt.of(this.settings.getLightValueFunction().applyAsInt(this.getMaterial()));
        }
        return this.lightValue.getAsInt();
    }

    public float m_7325_() {
        if (!this.explosionResistance.isPresent()) {
            this.explosionResistance = OptionalDouble.of(this.settings.getExplosionResistanceFunction().applyAsDouble(this.getMaterial()));
        }
        return (float)this.explosionResistance.getAsDouble();
    }

    public int getFlammability(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        if (!this.flammability.isPresent()) {
            this.flammability = OptionalInt.of(this.settings.getFireSpreadSpeedFunction().applyAsInt(this.getMaterial()));
        }
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(BlockState blockState, BlockGetter world, BlockPos pos, Direction face) {
        if (!this.fireSpreadSpeed.isPresent()) {
            this.fireSpreadSpeed = OptionalInt.of(this.settings.getFlammabilityFunction().applyAsInt(this.getMaterial()));
        }
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(BlockState blockState, LevelReader world, BlockPos pos, Direction side) {
        if (!this.isFireSource.isPresent()) {
            this.isFireSource = Optional.of(this.settings.getIsFireSourceFunction().test(this.getMaterial()));
        }
        return this.isFireSource.get();
    }

    public void m_7892_(BlockState blockState, Level world, BlockPos pos, Entity entity) {
        int time;
        if (!this.fireTime.isPresent()) {
            this.fireTime = OptionalInt.of(this.settings.getFireTimeFunction().applyAsInt(this.getMaterial()));
        }
        if ((time = this.fireTime.getAsInt()) > 0) {
            entity.m_20254_(time);
        }
    }
}

