/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import thelm.jaopca.api.resources.IInMemoryResourcePack;

public class InMemoryResourcePack
implements IInMemoryResourcePack {
    private static final Gson GSON = new GsonBuilder().create();
    private final String name;
    private final boolean isHidden;
    private final JsonObject metadata = (JsonObject)JsonParser.parseString((String)"{\"pack_format\":4,\"description\":\"JAOPCA In Memory Resources\"}");
    private final TreeMap<String, Supplier<? extends InputStream>> root = new TreeMap();
    private final TreeMap<ResourceLocation, Supplier<? extends InputStream>> assets = new TreeMap();
    private final TreeMap<ResourceLocation, Supplier<? extends InputStream>> data = new TreeMap();

    public InMemoryResourcePack(String name, boolean isHidden) {
        this.name = name;
        this.isHidden = isHidden;
    }

    @Override
    public IInMemoryResourcePack putInputStream(PackType type, ResourceLocation location, Supplier<? extends InputStream> streamSupplier) {
        switch (type) {
            case CLIENT_RESOURCES: {
                this.assets.put(location, streamSupplier);
                break;
            }
            case SERVER_DATA: {
                this.data.put(location, streamSupplier);
            }
        }
        return this;
    }

    @Override
    public IInMemoryResourcePack putInputStreams(PackType type, Map<ResourceLocation, Supplier<? extends InputStream>> map) {
        switch (type) {
            case CLIENT_RESOURCES: {
                this.assets.putAll(map);
                break;
            }
            case SERVER_DATA: {
                this.data.putAll(map);
            }
        }
        return this;
    }

    @Override
    public IInMemoryResourcePack putByteArray(PackType type, ResourceLocation location, byte[] file) {
        return this.putInputStream(type, location, () -> new ByteArrayInputStream(file));
    }

    @Override
    public IInMemoryResourcePack putByteArrays(PackType type, Map<ResourceLocation, byte[]> map) {
        return this.putInputStreams(type, Maps.transformValues(map, file -> () -> new ByteArrayInputStream((byte[])file)));
    }

    @Override
    public IInMemoryResourcePack putString(PackType type, ResourceLocation location, String str) {
        return this.putByteArray(type, location, str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public IInMemoryResourcePack putStrings(PackType type, Map<ResourceLocation, String> map) {
        return this.putByteArrays(type, Maps.transformValues(map, str -> str.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public IInMemoryResourcePack putJson(PackType type, ResourceLocation location, JsonElement json) {
        return this.putString(type, location, GSON.toJson(json));
    }

    @Override
    public IInMemoryResourcePack putJsons(PackType type, Map<ResourceLocation, ? extends JsonElement> map) {
        return this.putStrings(type, Maps.transformValues(map, json -> GSON.toJson(json)));
    }

    public InputStream m_5542_(String fileName) throws IOException {
        if (fileName.contains("/") || fileName.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if (this.root.containsKey(fileName)) {
            return this.root.get(fileName).get();
        }
        throw new FileNotFoundException(fileName);
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> map;
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> treeMap = map = type == PackType.CLIENT_RESOURCES ? this.assets : this.data;
        if (map.containsKey(location)) {
            return (InputStream)((Supplier)map.get(location)).get();
        }
        throw new FileNotFoundException(location.toString());
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String namespace, String pathIn, Predicate<ResourceLocation> filter) {
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> map = type == PackType.CLIENT_RESOURCES ? this.assets : this.data;
        return map.keySet().stream().filter(rl -> rl.m_135827_().equals(namespace)).filter(rl -> rl.m_135815_().startsWith(pathIn)).filter(filter).toList();
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> map = type == PackType.CLIENT_RESOURCES ? this.assets : this.data;
        return map.containsKey(location);
    }

    public Set<String> m_5698_(PackType type) {
        TreeMap<ResourceLocation, Supplier<? extends InputStream>> map = type == PackType.CLIENT_RESOURCES ? this.assets : this.data;
        return map.keySet().stream().map(rl -> rl.m_135827_()).collect(Collectors.toSet());
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        return (T)(deserializer == PackMetadataSection.f_10366_ ? deserializer.m_6322_(this.metadata) : null);
    }

    public String m_8017_() {
        return this.name;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void close() {
    }
}

