/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.utils;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.TreeMultiset;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.DifferenceIngredient;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.ingredients.CompoundIngredientObject;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.ingredients.WrappedIngredient;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;

public class MiscHelper
implements IMiscHelper {
    public static final MiscHelper INSTANCE = new MiscHelper();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "JAOPCA Executor Thread"));
    private TagManager tagManager;
    private List<TagManager.LoadResult<?>> lastTagResults = List.of();
    private Map<ResourceKey<? extends Registry<?>>, SetMultimap<ResourceLocation, Object>> tagMap = new TreeMap();
    private static final Predicate<String> CONFIG_MATERIAL_PREDICATE = s -> s.equals("*") || s.startsWith("*") && MaterialType.fromName(s.substring(1)) != null || MaterialHandler.containsMaterial(s);
    private static final Predicate<String> CONFIG_MODULE_PREDICATE = s -> s.equals("*") || ModuleHandler.getModuleMap().containsKey(s);

    private MiscHelper() {
    }

    public void setTagManager(TagManager tagManager) {
        this.tagManager = tagManager;
    }

    @Override
    public ResourceLocation createResourceLocation(String location, String defaultNamespace) {
        if (StringUtils.contains((CharSequence)location, (int)58)) {
            return new ResourceLocation(location);
        }
        return new ResourceLocation(defaultNamespace, location);
    }

    @Override
    public ResourceLocation createResourceLocation(String location) {
        return this.createResourceLocation(location, "forge");
    }

    @Override
    public ResourceLocation getTagLocation(String form, String material) {
        return this.getTagLocation(form, material, "/");
    }

    @Override
    public ResourceLocation getTagLocation(String form, String material, String separator) {
        return this.createResourceLocation(form + (String)(StringUtils.isEmpty((CharSequence)material) ? "" : (StringUtils.isEmpty((CharSequence)separator) ? "/" : separator) + material));
    }

    @Override
    public ItemStack getItemStack(Object obj, int count) {
        ItemStack ret = this.getPreferredItemStack((Iterable)this.getIngredientResolved(obj).getRight(), count);
        return ret.m_41619_() ? ItemStack.f_41583_ : ret;
    }

    @Override
    public Ingredient getIngredient(Object obj) {
        return (Ingredient)this.getIngredientResolved(obj).getLeft();
    }

    public Pair<Ingredient, Set<Item>> getIngredientResolved(Object obj) {
        EmptyIngredient ing = EmptyIngredient.INSTANCE;
        LinkedHashSet<Item> items = new LinkedHashSet<Item>();
        if (obj instanceof Supplier) {
            Pair<Ingredient, Set<Item>> pair = this.getIngredientResolved(((Supplier)obj).get());
            ing = (Ingredient)pair.getLeft();
            items.addAll((Collection)pair.getRight());
        } else if (obj instanceof CompoundIngredientObject) {
            CompoundIngredientObject cObj = (CompoundIngredientObject)obj;
            List<Pair> ings = Arrays.stream(cObj.ingredients()).map(this::getIngredientResolved).toList();
            if (ings.size() == 1) {
                Pair pair = ings.get(0);
                ing = (Ingredient)pair.getLeft();
                items.addAll((Collection)pair.getRight());
            } else if (ings.size() > 1) {
                switch (cObj.type()) {
                    case UNION: {
                        if (ings.stream().allMatch(p -> ((Set)p.getRight()).isEmpty())) break;
                        ing = CompoundIngredient.of((Ingredient[])((Ingredient[])ings.stream().map(Pair::getLeft).toArray(Ingredient[]::new)));
                        items.addAll(ings.stream().map(Pair::getRight).reduce(new HashSet(), (s1, s2) -> {
                            s1.addAll(s2);
                            return s1;
                        }));
                        break;
                    }
                    case INTERSECTION: {
                        if (ings.stream().anyMatch(p -> ((Set)p.getRight()).isEmpty())) break;
                        ing = IntersectionIngredient.of((Ingredient[])((Ingredient[])ings.stream().map(Pair::getLeft).toArray(Ingredient[]::new)));
                        items.addAll(ings.stream().map(Pair::getRight).reduce(new HashSet(ForgeRegistries.ITEMS.getValues()), (s1, s2) -> {
                            s1.retainAll((Collection<?>)s2);
                            return s1;
                        }));
                        break;
                    }
                    case DIFFERENCE: {
                        Pair firstPair = ings.get(0);
                        if (((Set)firstPair.getRight()).isEmpty()) break;
                        ing = DifferenceIngredient.of((Ingredient)((Ingredient)firstPair.getLeft()), (Ingredient)CompoundIngredient.of((Ingredient[])((Ingredient[])ings.stream().skip(1L).map(Pair::getLeft).toArray(Ingredient[]::new))));
                        items.addAll((Collection)firstPair.getRight());
                        items.removeAll(ings.stream().skip(1L).map(Pair::getRight).reduce(new HashSet(), (s1, s2) -> {
                            s1.addAll(s2);
                            return s1;
                        }));
                    }
                }
            }
        } else if (obj instanceof Ingredient) {
            ing = (Ingredient)obj;
            items.addAll(ForgeRegistries.ITEMS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = Ingredient.m_204132_(this.getItemTagKey(location));
            items.addAll(this.getItemTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = Ingredient.m_204132_(this.getItemTagKey(location));
            items.addAll(this.getItemTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = Ingredient.m_204132_((TagKey)key);
            items.addAll(this.getItemTagValues(key.f_203868_()));
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            ing = Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
            items.add(stack.m_41720_());
        } else if (obj instanceof ItemStack[]) {
            ItemStack[] stacks = (ItemStack[])obj;
            ing = Ingredient.m_43927_((ItemStack[])stacks);
            Arrays.stream(stacks).map(ItemStack::m_41720_).forEach(items::add);
        } else if (obj instanceof ItemLike) {
            ItemLike item = (ItemLike)obj;
            ing = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
            items.add(item.m_5456_());
        } else if (obj instanceof ItemLike[]) {
            ItemLike[] itemz = (ItemLike[])obj;
            ing = Ingredient.m_43929_((ItemLike[])itemz);
            Arrays.stream(itemz).map(ItemLike::m_5456_).forEach(items::add);
        } else if (obj instanceof Ingredient.Value) {
            ing = Ingredient.m_43938_(Stream.of((Ingredient.Value)obj));
            items.addAll(ForgeRegistries.ITEMS.getValues());
        } else if (obj instanceof Ingredient.Value[]) {
            ing = Ingredient.m_43938_(Stream.of((Ingredient.Value[])obj));
            items.addAll(ForgeRegistries.ITEMS.getValues());
        } else if (obj instanceof JsonElement) {
            ing = Ingredient.m_43917_((JsonElement)((JsonElement)obj));
            items.addAll(ForgeRegistries.ITEMS.getValues());
        }
        return Pair.of((Object)((Object)(items.isEmpty() ? EmptyIngredient.INSTANCE : ing)), items);
    }

    @Override
    public TagKey<Item> getItemTagKey(ResourceLocation location) {
        return this.getTagKey(Registry.f_122904_, location);
    }

    @Override
    public Collection<Item> getItemTagValues(ResourceLocation location) {
        return this.getTagValues(Registry.f_122904_, location);
    }

    @Override
    public ItemStack getPreferredItemStack(Iterable<Item> iterable, int count) {
        return new ItemStack((ItemLike)this.getPreferredEntry(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getKey(arg_0), iterable).orElse(Items.f_41852_), count);
    }

    @Override
    public FluidStack getFluidStack(Object obj, int amount) {
        FluidStack ret = FluidStack.EMPTY;
        if (obj instanceof Supplier) {
            ret = this.getFluidStack(((Supplier)obj).get(), amount);
        } else if (obj instanceof FluidStack) {
            ret = (FluidStack)obj;
        } else if (obj instanceof Fluid) {
            ret = new FluidStack((Fluid)obj, amount);
        } else if (obj instanceof IFluidLike) {
            ret = new FluidStack(((IFluidLike)obj).asFluid(), amount);
        } else if (obj instanceof String) {
            ret = this.getPreferredFluidStack(this.getFluidTagValues(new ResourceLocation((String)obj)), amount);
        } else if (obj instanceof ResourceLocation) {
            ret = this.getPreferredFluidStack(this.getFluidTagValues((ResourceLocation)obj), amount);
        } else if (obj instanceof TagKey) {
            ret = this.getPreferredFluidStack(this.getFluidTagValues(((TagKey)obj).f_203868_()), amount);
        }
        return ret.isEmpty() ? FluidStack.EMPTY : ret;
    }

    @Override
    public TagKey<Fluid> getFluidTagKey(ResourceLocation location) {
        return this.getTagKey(Registry.f_122899_, location);
    }

    @Override
    public Collection<Fluid> getFluidTagValues(ResourceLocation location) {
        return this.getTagValues(Registry.f_122899_, location);
    }

    @Override
    public FluidStack getPreferredFluidStack(Iterable<Fluid> iterable, int amount) {
        return new FluidStack(this.getPreferredEntry(arg_0 -> ((IForgeRegistry)ForgeRegistries.FLUIDS).getKey(arg_0), iterable).orElse(Fluids.f_76191_), amount);
    }

    @Override
    public <T> TagKey<T> getTagKey(ResourceKey<? extends Registry<T>> registry, ResourceLocation location) {
        return RegistryManager.ACTIVE.getRegistry(registry).tags().createTagKey(location);
    }

    @Override
    public <T> TagKey<T> getTagKey(ResourceLocation registry, ResourceLocation location) {
        return RegistryManager.ACTIVE.getRegistry(registry).tags().createTagKey(location);
    }

    @Override
    public <T> Collection<T> getTagValues(ResourceKey<? extends Registry<T>> registry, ResourceLocation location) {
        if (this.tagManager == null) {
            throw new IllegalStateException("Tag manager not initialized.");
        }
        if (this.tagManager.m_203904_() != this.lastTagResults) {
            this.lastTagResults = this.tagManager.m_203904_();
            this.tagMap.clear();
            if (this.lastTagResults.isEmpty()) {
                throw new IllegalStateException("Tags have not been loaded yet.");
            }
            this.lastTagResults.forEach(result -> {
                SetMultimap map = this.tagMap.computeIfAbsent(result.f_203928_(), k -> MultimapBuilder.treeKeys().linkedHashSetValues().build());
                result.f_203929_().forEach((loc, tag) -> tag.forEach(holder -> map.put(loc, holder.m_203334_())));
            });
        }
        return Collections2.transform((Collection)this.tagMap.getOrDefault(registry, (SetMultimap<ResourceLocation, Object>)ImmutableSetMultimap.of()).asMap().getOrDefault(location, Set.of()), o -> o);
    }

    @Override
    public <T> Collection<T> getTagValues(ResourceLocation registry, ResourceLocation location) {
        return this.getTagValues(RegistryManager.ACTIVE.getRegistry(registry).getRegistryKey(), location);
    }

    @Override
    public <T> Optional<T> getPreferredEntry(Function<T, ResourceLocation> keyGetter, Iterable<T> iterable) {
        Object preferredEntry = null;
        int currBest = ConfigHandler.PREFERRED_MODS.size();
        for (T entry : iterable) {
            ResourceLocation rl = keyGetter.apply(entry);
            if (rl == null) continue;
            String modId = rl.m_135827_();
            int idx = ConfigHandler.PREFERRED_MODS.indexOf(modId);
            if (preferredEntry != null && (idx < 0 || idx >= currBest)) continue;
            preferredEntry = entry;
            if (idx < 0) continue;
            currBest = idx;
        }
        return Optional.ofNullable(preferredEntry);
    }

    @Override
    public void caclulateMaterialSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = configList.stream().map(s -> s.startsWith("*") ? s.toLowerCase(Locale.US) : s).collect(Collectors.toCollection(TreeMultiset::create));
        int listCount = list.count((Object)"*");
        MaterialHandler.getMaterials().forEach(m -> list.add((Object)m.getName(), listCount));
        list.remove((Object)"*", listCount);
        for (MaterialType type : MaterialType.values()) {
            int listCount1 = list.count((Object)("*" + type.getName()));
            MaterialHandler.getMaterials().stream().filter(m -> m.getType() == type).forEach(m -> list.add((Object)m.getName(), listCount1));
            list.remove((Object)("*" + type.getName()), listCount1);
        }
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public void caclulateModuleSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = TreeMultiset.create(configList);
        int listCount = list.count((Object)"*");
        ModuleHandler.getModules().forEach(m -> list.add((Object)m.getName(), listCount));
        list.remove((Object)"*", listCount);
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public Ingredient wrapIngredient(Ingredient ing) {
        return WrappedIngredient.of(ing);
    }

    @Override
    public JsonObject serializeItemStack(ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        json.addProperty("count", (Number)stack.m_41613_());
        if (stack.m_41782_()) {
            json.addProperty("nbt", stack.m_41783_().toString());
        }
        return json;
    }

    @Override
    public JsonObject serializeFluidStack(FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()).toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }

    @Override
    public Predicate<String> configMaterialPredicate() {
        return CONFIG_MATERIAL_PREDICATE;
    }

    @Override
    public Predicate<String> configModulePredicate() {
        return CONFIG_MODULE_PREDICATE;
    }

    @Override
    public Runnable conditionalRunnable(BooleanSupplier conditionSupplier, Supplier<Runnable> trueRunnable, Supplier<Runnable> falseRunnable) {
        return () -> ((Runnable)(conditionSupplier.getAsBoolean() ? trueRunnable : falseRunnable).get()).run();
    }

    @Override
    public <T> Supplier<T> conditionalSupplier(BooleanSupplier conditionSupplier, Supplier<Supplier<T>> trueSupplier, Supplier<Supplier<T>> falseSupplier) {
        return () -> ((Supplier)(conditionSupplier.getAsBoolean() ? trueSupplier : falseSupplier).get()).get();
    }

    @Override
    public boolean hasResource(ResourceLocation location) {
        return (Boolean)DistExecutor.unsafeRunForDist(() -> () -> Minecraft.m_91087_().m_91098_().m_213713_(location).isPresent(), () -> () -> false);
    }

    public <T> Future<T> submitAsyncTask(Callable<T> task) {
        return this.executor.submit(task);
    }

    public Future<?> submitAsyncTask(Runnable task) {
        return this.executor.submit(task);
    }

    public int squareColorDifference(int color1, int color2) {
        int diffR = (color1 << 16 & 0xFF) - (color2 << 16 & 0xFF);
        int diffG = (color1 << 8 & 0xFF) - (color2 << 8 & 0xFF);
        int diffB = (color1 & 0xFF) - (color2 & 0xFF);
        return diffR * diffR + diffG * diffG + diffB * diffB;
    }

    public Predicate<String> modVersionNotLoaded(Logger logger) {
        return dep -> {
            VersionRange versionRange;
            ModList modList = ModList.get();
            int separatorIndex = dep.lastIndexOf(64);
            String modId = dep.substring(0, separatorIndex == -1 ? dep.length() : separatorIndex);
            String spec = separatorIndex == -1 ? "0" : dep.substring(separatorIndex + 1);
            try {
                versionRange = VersionRange.createFromVersionSpec((String)spec);
            }
            catch (InvalidVersionSpecificationException e) {
                logger.warn("Unable to parse version spec {} for mod id {}", (Object)spec, (Object)modId, (Object)e);
                return true;
            }
            if (modList.isLoaded(modId)) {
                ArtifactVersion version = ((ModContainer)modList.getModContainerById(modId).get()).getModInfo().getVersion();
                if (versionRange.containsVersion(version)) {
                    return false;
                }
                logger.warn("Mod {} in version range {} was requested, was {}", (Object)modId, (Object)versionRange, (Object)version);
                return true;
            }
            return true;
        };
    }

    public boolean classNotExists(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }
}

