/*
 * Decompiled with CFR 0.152.
 */
package io.github.bluesheep2804.jaopcaextras.modules;

import io.github.bluesheep2804.jaopcaextras.init.ItemInit;
import io.github.bluesheep2804.jaopcaextras.recipes.AE2InscriberRecipeSerializer;
import io.github.bluesheep2804.jaopcaextras.recipes.LazierAE2EtcherRecipeSerializer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.api.recipes.IRecipeSerializer;

@JAOPCAModule(modDependencies={"ae2"})
public class AE2Module
implements IModule {
    private final JAOPCAApi api = JAOPCAApi.instance();
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("brick", "nether_brick", "prismarine", "sulfur", "diamond", "certus_quartz", "gold", "resonating"));
    private final IForm processorForm = this.api.newForm((IModule)this, "processors", (IFormType)this.api.itemFormType()).setMaterialTypes(MaterialType.NON_DUSTS).setDefaultMaterialBlacklist(BLACKLIST);
    private final IForm circuitForm = this.api.newForm((IModule)this, "circuits", (IFormType)this.api.itemFormType()).setMaterialTypes(MaterialType.NON_DUSTS).setDefaultMaterialBlacklist(BLACKLIST);

    public String getName() {
        return "extras_ae2";
    }

    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.api.newFormRequest((IModule)this, new IForm[]{this.circuitForm, this.processorForm}));
    }

    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        IMiscHelper miscHelper = this.api.miscHelper();
        Item press = (Item)ItemInit.EXTRA_PRESS.get();
        Item universalPress = null;
        if (ModList.get().isLoaded("lazierae2")) {
            universalPress = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("lazierae2:universal_press"));
        }
        for (IMaterial material : this.circuitForm.getMaterials()) {
            String name = material.getName();
            if (BLACKLIST.contains(name)) continue;
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), name);
            IItemInfo circuitInfo = this.api.itemFormType().getMaterialFormInfo(this.circuitForm, material);
            this.api.registerRecipe(new ResourceLocation("jaopcaextras", "inscriber.circuit." + material.getName()), (IRecipeSerializer)new AE2InscriberRecipeSerializer("inscribe", materialLocation, press, circuitInfo));
            if (universalPress == null) continue;
            this.api.registerRecipe(new ResourceLocation("jaopcaextras", "inscriber.circuit.universal." + material.getName()), (IRecipeSerializer)new AE2InscriberRecipeSerializer("inscribe", materialLocation, universalPress, circuitInfo));
        }
        ResourceLocation silicon = new ResourceLocation("forge", "silicon");
        ResourceLocation redstone = miscHelper.getTagLocation("dusts", "redstone");
        for (IMaterial material : this.processorForm.getMaterials()) {
            String name = material.getName();
            if (BLACKLIST.contains(name)) continue;
            ResourceLocation circuitLocation = miscHelper.getTagLocation("circuits", material.getName());
            IItemInfo processorInfo = this.api.itemFormType().getMaterialFormInfo(this.processorForm, material);
            this.api.registerRecipe(new ResourceLocation("jaopcaextras", "inscriber.processor." + material.getName()), (IRecipeSerializer)new AE2InscriberRecipeSerializer("press", redstone, circuitLocation, processorInfo));
            if (universalPress == null) continue;
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), name);
            this.api.registerRecipe(new ResourceLocation("jaopcaextras", "etcher.processor." + material.getName()), (IRecipeSerializer)new LazierAE2EtcherRecipeSerializer(new ResourceLocation[]{materialLocation, redstone, silicon}, processorInfo));
        }
    }
}

