/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.toolkit.commands.inventory;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sunekaer.toolkit.commands.inventory.InventoryCollector;
import com.sunekaer.toolkit.network.Handler;
import com.sunekaer.toolkit.network.SetCopy;
import com.sunekaer.toolkit.utils.CommandUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class CopyCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"copy").then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests(InventoryCollector::suggestions).executes(CopyCommand::copy));
    }

    private static int copy(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        InventoryCollector type = InventoryCollector.fromString(StringArgumentType.getString(context, (String)"type"));
        if (type == null) {
            source.m_81352_((Component)Component.m_237113_((String)"Invalid type"));
            return 0;
        }
        ServerPlayer player = source.m_81375_();
        List<ItemStack> itemCollection = type.itemCollector.apply((Player)player);
        StringBuilder clipboard = new StringBuilder();
        for (ItemStack stack : itemCollection) {
            if (stack.m_41619_()) continue;
            String itemName = Objects.requireNonNull(Registry.f_122827_.m_7981_((Object)stack.m_41720_())).toString();
            Object withNBT = "";
            CompoundTag nbt = stack.m_41739_(new CompoundTag());
            if (nbt.m_128441_("tag")) {
                withNBT = (String)withNBT + nbt.m_128423_("tag");
            }
            clipboard.append(itemName).append((String)withNBT).append(CommandUtils.NEW_LINE);
        }
        source.m_81354_((Component)Component.m_237115_((String)"commands.toolkit.clipboard.copied"), true);
        Handler.CHANNEL.sendToPlayer(player, (Object)new SetCopy(clipboard.toString()));
        return 1;
    }
}

