/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraftforge.resource.PathPackResources;
import net.minecraftforge.resource.ResourceCacheManager;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PathPackResources.class})
public class ForgePathPackResourcesMixin
implements PackResourcesExtension {
    @Final
    @Shadow(remap=false)
    private Path source;
    @Unique
    private String overridesFolderName;
    @Final
    @Shadow(remap=false)
    private ResourceCacheManager cacheManager;

    @Override
    public void setFusionOverridesFolder(@NotNull String folder) {
        this.overridesFolderName = folder;
    }

    @Shadow(remap=false)
    private Path resolve(String ... paths) {
        throw new AssertionError();
    }

    @Inject(method={"getResource(Ljava/lang/String;)Ljava/io/InputStream;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(String path, CallbackInfoReturnable<InputStream> ci) throws IOException {
        if (this.overridesFolderName == null) {
            return;
        }
        Path resolvedPath = this.resolve(this.overridesFolderName, path);
        if (Files.exists(resolvedPath, new LinkOption[0])) {
            ci.setReturnValue((Object)Files.newInputStream(resolvedPath, StandardOpenOption.READ));
        }
    }

    @Inject(method={"hasResource(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hasResource(String path, CallbackInfoReturnable<Boolean> ci) {
        if (this.overridesFolderName == null) {
            return;
        }
        if (Files.exists(this.resolve(this.overridesFolderName, path), new LinkOption[0])) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getNamespacesFromDisk"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private void getNamespacesFromDisk(PackType type, CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolderName == null) {
            return;
        }
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        Path typeFolder = this.resolve(this.overridesFolderName, type.m_10305_());
        try (Stream<Path> walker = Files.walk(typeFolder, 1, new FileVisitOption[0]);){
            walker.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(typeFolder::relativize).filter(p -> p.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).forEach(namespaces::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ci.setReturnValue((Object)namespaces);
    }

    @Inject(method={"getResources"}, at={@At(value="RETURN")}, cancellable=true)
    private void getResources(PackType type, String namespace, String folderName, Predicate<ResourceLocation> predicate, CallbackInfoReturnable<Collection<ResourceLocation>> ci) {
        if (this.overridesFolderName == null) {
            return;
        }
        if (ResourceCacheManager.shouldUseCache() && this.cacheManager.hasCached(type, namespace)) {
            return;
        }
        if (ci.getReturnValue() == null) {
            return;
        }
        ArrayList locations = new ArrayList((Collection)ci.getReturnValue());
        HashSet locationSet = new HashSet(locations);
        Path namespaceFolder = this.resolve(this.overridesFolderName, type.m_10305_(), namespace).toAbsolutePath();
        Path searchFolder = namespaceFolder.getFileSystem().getPath(folderName, new String[0]);
        try (Stream<Path> walker = Files.walk(namespaceFolder, new FileVisitOption[0]);){
            walker.map(namespaceFolder::relativize).filter(path -> !path.toString().endsWith(".mcmeta") && path.startsWith(searchFolder)).map(arg_0 -> ((Joiner)Joiner.on((char)'/')).join(arg_0)).filter(ResourceLocation::m_135841_).map(path -> new ResourceLocation(namespace, path)).filter(Predicate.not(locationSet::contains)).filter(predicate).forEach(locations::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ci.setReturnValue(locations);
    }
}

