/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.mojang.blaze3d.platform.PngInfo;
import com.mojang.datafixers.util.Pair;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={TextureAtlas.class}, priority=900)
public class TextureAtlasMixin {
    @Unique
    private final Map<ResourceLocation, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>> fusionTextureMetadata = new HashMap<ResourceLocation, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"lambda$getBasicSpriteInfos$2(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/server/packs/resources/ResourceManager;Ljava/util/Queue;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/TextureAtlasSprite$Info;<init>(Lnet/minecraft/resources/ResourceLocation;IILnet/minecraft/client/resources/metadata/animation/AnimationMetadataSection;)V", shift=At.Shift.BY, by=2)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void gatherMetadata(ResourceLocation identifier, ResourceManager resourceManager, Queue<?> queue, CallbackInfo ci, ResourceLocation location, Optional<?> optional, Resource resource, PngInfo pngInfo, AnimationMetadataSection animationMetadataSection, Pair<?, ?> pair, TextureAtlasSprite.Info info) {
        com.supermartijn642.fusion.api.util.Pair metadata = null;
        try {
            metadata = resource.m_215509_().m_214059_((MetadataSectionSerializer)FusionTextureMetadataSection.INSTANCE).orElse(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (metadata != null) {
            com.supermartijn642.fusion.api.util.Pair<Integer, Integer> newSize;
            Map<ResourceLocation, com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object>> map = this.fusionTextureMetadata;
            synchronized (map) {
                this.fusionTextureMetadata.put(info.m_118431_(), metadata);
            }
            try {
                newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl(info.m_118434_(), info.m_118437_(), pngInfo.f_85207_, pngInfo.f_85208_, identifier), metadata.right());
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + location + "'!", e);
            }
            if (newSize == null) {
                throw new RuntimeException("Received null frame size from texture type '" + TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left()) + "' for texture '" + location + "'!");
            }
            info.f_118423_ = newSize.left();
            info.f_118424_ = newSize.right();
        }
    }

    @Inject(method={"getLoadedSprites(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/client/renderer/texture/Stitcher;I)Ljava/util/List;"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void getLoadedSprites(ResourceManager resourceManager, Stitcher stitcher, int i, CallbackInfoReturnable<List<TextureAtlasSprite>> ci) {
        List textures = (List)ci.getReturnValue();
        if (textures != null) {
            for (int index = 0; index < textures.size(); ++index) {
                TextureAtlasSprite newTexture;
                TextureAtlasSprite texture = (TextureAtlasSprite)textures.get(index);
                com.supermartijn642.fusion.api.util.Pair<TextureType<Object>, Object> textureData = this.fusionTextureMetadata.get(texture.m_118413_());
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl(texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + texture.m_118413_() + "' for texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + TextureTypeRegistryImpl.getIdentifier(textureData.left()) + "' for texture '" + texture.m_118413_() + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.set(index, newTexture);
            }
        }
        this.fusionTextureMetadata.clear();
    }
}

