/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.oitsjustjose.natprog.Constants;
import com.oitsjustjose.natprog.NatProg;
import com.oitsjustjose.natprog.NatProgGroup;
import com.oitsjustjose.natprog.common.blocks.PebbleBlock;
import com.oitsjustjose.natprog.common.blocks.TwigBlock;
import com.oitsjustjose.natprog.common.data.damageitem.DamageItemRecipeSerializer;
import com.oitsjustjose.natprog.common.data.damageitem.DamageItemRecipeType;
import com.oitsjustjose.natprog.common.items.DynamicItemTier;
import com.oitsjustjose.natprog.common.items.PebbleItem;
import com.oitsjustjose.natprog.common.items.SawItem;
import com.oitsjustjose.natprog.common.world.feature.PebbleFeature;
import com.oitsjustjose.natprog.common.world.feature.TwigFeature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class Registry {
    public final DeferredRegister<Block> BlockRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"natprog");
    public final DeferredRegister<Item> ItemRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"natprog");
    public final DeferredRegister<RecipeType<?>> RecipeTypeRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"natprog");
    public final DeferredRegister<RecipeSerializer<?>> SerializerRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"natprog");
    public final DeferredRegister<Feature<?>> FeatureRegistry = DeferredRegister.create((ResourceKey)net.minecraft.core.Registry.f_122838_, (String)"natprog");
    public final DeferredRegister<ConfiguredFeature<?, ?>> ConfiguredFeatureRegistry = DeferredRegister.create((ResourceKey)net.minecraft.core.Registry.f_122881_, (String)"natprog");
    public final DeferredRegister<PlacedFeature> PlacedFeatureRegistry = DeferredRegister.create((ResourceKey)net.minecraft.core.Registry.f_194567_, (String)"natprog");
    public static Tier flintTier = new DynamicItemTier().setMaxUses(16).setEfficiency(1.5f).setAttackDamage(1.0f).setHarvestLvl(0).setEnchantability(0).setRepairMats(Items.f_42484_);
    public static Tier boneTier = new DynamicItemTier().setMaxUses(128).setEfficiency(2.0f).setAttackDamage(2.0f).setHarvestLvl(1).setEnchantability(0).setRepairMats(Items.f_42500_);
    public static Tier copperTier = new DynamicItemTier().setMaxUses(192).setEfficiency(1.65f).setAttackDamage(1.5f).setHarvestLvl(0).setEnchantability(0).setRepairMat((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("forge:ingots/copper")));
    public static Tier bronzeTier = new DynamicItemTier().setMaxUses(442).setEfficiency(2.5f).setAttackDamage(2.5f).setHarvestLvl(2).setEnchantability(0).setRepairMat((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("forge:ingots/bronze")));
    public static Tier steelTier = new DynamicItemTier().setMaxUses(914).setEfficiency(3.5f).setAttackDamage(3.5f).setHarvestLvl(3).setEnchantability(0).setRepairMat((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("forge:ingots/steel")));
    public RegistryObject<Item> flintHatchet;
    public RegistryObject<Item> bonePickaxe;
    public RegistryObject<Item> boneKnife;
    public RegistryObject<Item> boneShard;
    public RegistryObject<Item> ironSaw;
    public RegistryObject<Item> flintSaw;
    public RegistryObject<Item> goldSaw;
    public RegistryObject<Item> diamondSaw;
    public RegistryObject<Item> netheriteSaw;
    public RegistryObject<Item> copperSaw;
    public RegistryObject<Item> bronzeSaw;
    public RegistryObject<Item> steelSaw;
    public RegistryObject<Block> twigBlock;
    private final List<RegistryObject<? extends Block>> NeedItemBlocks = Lists.newArrayList();
    public final HashMap<ResourceLocation, RegistryObject<? extends Block>> Mapper = new HashMap();

    public Registry() {
        this.RegisterBlocks();
        this.RegisterItems();
        this.RegisterRecipeStuff();
        this.RegisterWorldGen();
    }

    public void RegisterAll(FMLJavaModLoadingContext ctx) {
        this.BlockRegistry.register(ctx.getModEventBus());
        this.ItemRegistry.register(ctx.getModEventBus());
        this.RecipeTypeRegistry.register(ctx.getModEventBus());
        this.SerializerRegistry.register(ctx.getModEventBus());
        this.FeatureRegistry.register(ctx.getModEventBus());
        this.ConfiguredFeatureRegistry.register(ctx.getModEventBus());
        this.PlacedFeatureRegistry.register(ctx.getModEventBus());
    }

    private void RegisterBlocks() {
        this.twigBlock = this.BlockRegistry.register("twigs", TwigBlock::new);
        Constants.PebbleMaterials.forEach(rl -> {
            String generated = (String)(rl.m_135827_().equals("minecraft") ? "" : rl.m_135827_() + "_") + rl.m_135815_() + "_pebble";
            RegistryObject block = this.BlockRegistry.register(generated, () -> new PebbleBlock((ResourceLocation)rl));
            this.Mapper.put((ResourceLocation)rl, (RegistryObject<? extends Block>)block);
            this.NeedItemBlocks.add((RegistryObject<? extends Block>)block);
        });
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56742_);
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_andesite", () -> new Block(properties)));
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_diorite", () -> new Block(properties)));
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_granite", () -> new Block(properties)));
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_sandstone", () -> new Block(properties)));
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_red_sandstone", () -> new Block(properties)));
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_tuff", () -> new Block(properties)));
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_dripstone_block", () -> new Block(properties)));
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_netherrack", () -> new Block(properties)));
        this.NeedItemBlocks.add((RegistryObject<? extends Block>)this.BlockRegistry.register("cobbled_end_stone", () -> new Block(properties)));
        NatProg.getInstance().LOGGER.info(this.NeedItemBlocks);
    }

    private void RegisterItems() {
        NatProgGroup tab = NatProgGroup.getInstance();
        this.NeedItemBlocks.forEach(x -> {
            Item.Properties props = new Item.Properties();
            ResourceLocation rn = x.getId();
            this.ItemRegistry.register(rn.m_135815_(), () -> {
                Block block = (Block)x.get();
                if (block instanceof PebbleBlock) {
                    PebbleBlock pebble = (PebbleBlock)block;
                    return new PebbleItem(block, pebble.getParentBlock() == null ? props : props.m_41491_((CreativeModeTab)tab));
                }
                return new BlockItem(block, props.m_41491_((CreativeModeTab)tab));
            });
        });
        Item.Properties props = new Item.Properties().m_41491_((CreativeModeTab)tab);
        this.flintHatchet = this.ItemRegistry.register("flint_hatchet", () -> new AxeItem(flintTier, 1.8f, 0.0f, props));
        this.bonePickaxe = this.ItemRegistry.register("bone_pickaxe", () -> new PickaxeItem(boneTier, 1, -2.8f, props));
        this.boneKnife = this.ItemRegistry.register("bone_knife", () -> new SwordItem(boneTier, 1, -1.4f, props));
        this.boneShard = this.ItemRegistry.register("bone_shard", () -> new Item(props));
        this.flintSaw = this.ItemRegistry.register("flint_saw", () -> new SawItem(flintTier));
        this.ironSaw = this.ItemRegistry.register("iron_saw", () -> new SawItem((Tier)Tiers.IRON));
        this.goldSaw = this.ItemRegistry.register("gold_saw", () -> new SawItem((Tier)Tiers.GOLD));
        this.diamondSaw = this.ItemRegistry.register("diamond_saw", () -> new SawItem((Tier)Tiers.DIAMOND));
        this.netheriteSaw = this.ItemRegistry.register("netherite_saw", () -> new SawItem((Tier)Tiers.NETHERITE, true));
        this.copperSaw = this.ItemRegistry.register("copper_saw", () -> new SawItem(copperTier));
        this.bronzeSaw = this.ItemRegistry.register("bronze_saw", () -> new SawItem(bronzeTier));
        this.steelSaw = this.ItemRegistry.register("steel_saw", () -> new SawItem(steelTier));
    }

    public void RegisterRecipeStuff() {
        this.SerializerRegistry.register("damage_tools", DamageItemRecipeSerializer::new);
        this.RecipeTypeRegistry.register("damage_tools", DamageItemRecipeType::new);
    }

    public void RegisterWorldGen() {
        ArrayList placement = Lists.newArrayList((Object[])new PlacementModifier[]{HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)-64), (VerticalAnchor)VerticalAnchor.m_158922_((int)320))});
        RegistryObject pebbles = this.FeatureRegistry.register("pebbles", () -> new PebbleFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        RegistryObject configuredPebbles = this.ConfiguredFeatureRegistry.register("pebbles_configured", () -> new ConfiguredFeature((Feature)pebbles.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        this.PlacedFeatureRegistry.register("pebbles_placed", () -> {
            if (configuredPebbles.getHolder().isEmpty()) {
                throw new RuntimeException("Failed to get configured feature natprog:pebbles_configured from holder, something has seriously broken. Please report this to oitsjustjose via https://discord.oitsjustjose.com");
            }
            return new PlacedFeature((Holder)configuredPebbles.getHolder().get(), placement);
        });
        RegistryObject twigs = this.FeatureRegistry.register("twigs", () -> new TwigFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        RegistryObject configuredTwigs = this.ConfiguredFeatureRegistry.register("twigs_configured", () -> new ConfiguredFeature((Feature)twigs.get(), (FeatureConfiguration)NoneFeatureConfiguration.f_67816_));
        this.PlacedFeatureRegistry.register("twigs_placed", () -> {
            if (configuredTwigs.getHolder().isEmpty()) {
                throw new RuntimeException("Failed to get configured feature natprog:twigs_configured from holder, something has seriously broken. Please report this to oitsjustjose via https://discord.oitsjustjose.com");
            }
            return new PlacedFeature((Holder)configuredTwigs.getHolder().get(), placement);
        });
    }
}

