/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common.event;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oitsjustjose.natprog.common.config.CommonConfig;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ToolNeutering {
    public static final TagKey<Item> ALLOWED_WOOD_TOOLS = ItemTags.create((ResourceLocation)new ResourceLocation("natprog", "allowed_wooden_tools"));
    public static final TagKey<Item> ALLOWED_STONE_TOOLS = ItemTags.create((ResourceLocation)new ResourceLocation("natprog", "allowed_stone_tools"));

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onHover(ItemTooltipEvent evt) {
        TranslatableContents content2;
        ItemStack stack = evt.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_204117_(ALLOWED_WOOD_TOOLS) || stack.m_204117_(ALLOWED_STONE_TOOLS)) {
            return;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof TieredItem)) {
            return;
        }
        TieredItem tiered = (TieredItem)item;
        if (tiered.m_43314_() != Tiers.WOOD || !((Boolean)CommonConfig.REMOVE_WOODEN_TOOL_FUNC.get()).booleanValue()) {
            return;
        }
        try {
            content2 = new TranslatableContents("natprog.too.brittle");
            evt.getToolTip().add(content2.m_213698_(null, null, 0));
        }
        catch (CommandSyntaxException content2) {
            // empty catch block
        }
        if (tiered.m_43314_() != Tiers.STONE || !((Boolean)CommonConfig.REMOVE_STONE_TOOL_FUNC.get()).booleanValue()) {
            return;
        }
        try {
            content2 = new TranslatableContents("natprog.too.blunt");
            evt.getToolTip().add(content2.m_213698_(null, null, 0));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void registerEvent(PlayerEvent.BreakSpeed evt) {
        boolean cancelStone;
        if (!((Boolean)CommonConfig.TOOL_NEUTERING.get()).booleanValue()) {
            return;
        }
        ItemStack stack = evt.getEntity().m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_204117_(ALLOWED_WOOD_TOOLS) || stack.m_204117_(ALLOWED_STONE_TOOLS)) {
            return;
        }
        if (evt.getState() == null || evt.getEntity() == null) {
            return;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof TieredItem)) {
            return;
        }
        TieredItem tiered = (TieredItem)item;
        boolean cancelWood = tiered.m_43314_() == Tiers.WOOD && (Boolean)CommonConfig.REMOVE_WOODEN_TOOL_FUNC.get() != false;
        boolean bl = cancelStone = tiered.m_43314_() == Tiers.STONE && (Boolean)CommonConfig.REMOVE_STONE_TOOL_FUNC.get() != false;
        if (cancelWood || cancelStone) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void registerEvent(AttackEntityEvent evt) {
        boolean cancelStone;
        if (evt.getEntity() == null) {
            return;
        }
        ItemStack stack = evt.getEntity().m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (stack.m_204117_(ALLOWED_WOOD_TOOLS) || stack.m_204117_(ALLOWED_STONE_TOOLS)) {
            return;
        }
        Item item = stack.m_41720_();
        if (!(item instanceof TieredItem)) {
            return;
        }
        TieredItem tiered = (TieredItem)item;
        boolean cancelWood = tiered.m_43314_() == Tiers.WOOD && (Boolean)CommonConfig.REMOVE_WOODEN_TOOL_FUNC.get() != false;
        boolean bl = cancelStone = tiered.m_43314_() == Tiers.STONE && (Boolean)CommonConfig.REMOVE_STONE_TOOL_FUNC.get() != false;
        if (cancelWood || cancelStone) {
            evt.setCanceled(true);
        }
    }
}

