/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common.event.block;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oitsjustjose.natprog.NatProg;
import com.oitsjustjose.natprog.common.config.CommonConfig;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StoneBreak {
    public static final TagKey<Item> CONSIDERED_AS_PICKAXE = ItemTags.create((ResourceLocation)new ResourceLocation("natprog", "considered_as_pickaxe"));
    public static final TagKey<Block> IGNORED_STONE_BLOCKS = BlockTags.create((ResourceLocation)new ResourceLocation("natprog", "ignored_stone_blocks"));
    public static final List<Material> HEAVY_MATS = Lists.newArrayList((Object[])new Material[]{Material.f_76281_, Material.f_76279_, Material.f_76278_});
    final BrokenHandSource brokenHandSource = new BrokenHandSource();

    @SubscribeEvent
    public void registerEvent(PlayerEvent.BreakSpeed evt) {
        if (evt.getState() == null || evt.getEntity() == null) {
            return;
        }
        if (!HEAVY_MATS.contains(evt.getState().m_60767_())) {
            return;
        }
        if (evt.getState().m_204336_(IGNORED_STONE_BLOCKS)) {
            return;
        }
        ItemStack heldItem = evt.getEntity().m_21205_();
        if (heldItem.m_204117_(CONSIDERED_AS_PICKAXE)) {
            return;
        }
        if (heldItem.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return;
        }
        evt.setCanceled(true);
        if (evt.getEntity().m_21205_().m_41619_() && evt.getEntity().m_217043_().m_188503_(25) == 1 && ((Boolean)CommonConfig.INCORRECT_TOOL_DAMAGE.get()).booleanValue()) {
            if (evt.getEntity().m_217043_().m_188503_(2) == 1) {
                evt.getEntity().m_6469_((DamageSource)this.brokenHandSource, 1.0f);
            } else {
                NatProg.proxy.doHurtAnimation(evt.getEntity());
            }
        }
        if (!((Boolean)CommonConfig.SHOW_BREAKING_HELP.get()).booleanValue()) {
            return;
        }
        try {
            TranslatableContents contents = new TranslatableContents("natprog.stone.warning");
            MutableComponent comp = contents.m_213698_(null, null, 0);
            evt.getEntity().m_5661_((Component)comp, true);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
    }

    public static class BrokenHandSource
    extends DamageSource {
        BrokenHandSource() {
            super("broken hand");
        }

        @Nullable
        public Entity m_7640_() {
            return null;
        }

        @Nonnull
        public Component m_6157_(LivingEntity entityLivingBaseIn) {
            try {
                TranslatableContents contents = new TranslatableContents("natprog.broken.bones", new Object[]{entityLivingBaseIn.m_5446_()});
                return contents.m_213698_(null, null, 0);
            }
            catch (CommandSyntaxException ex) {
                NatProg.getInstance().LOGGER.info(ex.getMessage());
                return Component.m_237119_().m_130946_("Failed to resolve translation");
            }
        }
    }
}

