/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.natprog.common.world.feature;

import com.mojang.serialization.Codec;
import com.oitsjustjose.natprog.NatProg;
import com.oitsjustjose.natprog.common.Utils;
import com.oitsjustjose.natprog.common.blocks.PebbleBlock;
import com.oitsjustjose.natprog.common.config.CommonConfig;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PebbleFeature
extends Feature<NoneFeatureConfiguration> {
    public static final TagKey<Block> WONT_SUPPORT_PEBBLE = BlockTags.create((ResourceLocation)new ResourceLocation("natprog", "wont_support_pebble"));

    public PebbleFeature(Codec<NoneFeatureConfiguration> p_i231976_1_) {
        super(p_i231976_1_);
    }

    @ParametersAreNonnullByDefault
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> f) {
        if (f.m_159775_() instanceof FlatLevelSource) {
            return false;
        }
        WorldGenLevel level = f.m_159774_();
        BlockPos pos = f.m_159777_();
        try {
            for (int i = 0; i < (Integer)CommonConfig.MAX_PEBBLES_PER_CHUNK.get(); ++i) {
                Block pebble;
                BlockState stateToPlace;
                BlockPos pebblePos = Utils.getTopLevelPlacePos(level, new ChunkPos(pos));
                if (pebblePos == null || Utils.inNonWaterFluid(level, pebblePos) || level.m_8055_(pebblePos).m_204336_(WONT_SUPPORT_PEBBLE) || !level.m_7731_(pebblePos, stateToPlace = (BlockState)(pebble = Utils.getPebbleForPos(level, pebblePos)).m_49966_().m_61124_((Property)PebbleBlock.WATERLOGGED, (Comparable)Boolean.valueOf(Utils.isInWater(level, pebblePos))), 18)) continue;
                BlockPos posAbove = pebblePos.m_7494_();
                BlockState blockAbove = level.m_8055_(posAbove);
                if (blockAbove.m_61138_((Property)DoublePlantBlock.f_52858_) && blockAbove.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                    level.m_7731_(posAbove, Utils.isInWater(level, posAbove) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_(), 18);
                }
                Utils.fixSnowyBlock(level, pebblePos);
            }
        }
        catch (Exception e) {
            NatProg.getInstance().LOGGER.error(e.getMessage());
        }
        return true;
    }
}

