/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.networking.packet.client;

import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import com.teamresourceful.resourcefullib.common.networking.base.PacketContext;
import com.teamresourceful.resourcefullib.common.networking.base.PacketHandler;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import earth.terrarium.ad_astra.common.util.ModUtils;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public record TeleportToPlanetPacket(ResourceLocation id) implements Packet<TeleportToPlanetPacket>
{
    public static final ResourceLocation ID = new ResourceLocation("ad_astra", "teleport_to_planet_packet");
    public static final Handler HANDLER = new Handler();

    private static ResourceKey<Level> getlevel(ResourceLocation id) {
        ResourceKey targetDimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)id);
        if (targetDimension.m_135782_().equals((Object)new ResourceLocation("ad_astra", "earth"))) {
            targetDimension = Level.f_46428_;
        }
        return targetDimension;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public PacketHandler<TeleportToPlanetPacket> getHandler() {
        return HANDLER;
    }

    private static class Handler
    implements PacketHandler<TeleportToPlanetPacket> {
        private Handler() {
        }

        public void encode(TeleportToPlanetPacket packet, FriendlyByteBuf buf) {
            buf.m_130085_(packet.id);
        }

        public TeleportToPlanetPacket decode(FriendlyByteBuf buf) {
            return new TeleportToPlanetPacket(buf.m_130281_());
        }

        public PacketContext handle(TeleportToPlanetPacket packet) {
            return (player, level) -> {
                List<String> disabledPlanets = List.of(AdAstraConfig.disabledPlanets.split(","));
                if (!disabledPlanets.contains(packet.id().toString())) {
                    if (player.m_20202_() instanceof Rocket) {
                        ModUtils.teleportToLevel(TeleportToPlanetPacket.getlevel(packet.id()), (Entity)player);
                    } else if (player.m_36337_()) {
                        ModUtils.teleportPlayer(TeleportToPlanetPacket.getlevel(packet.id()), (ServerPlayer)player);
                    }
                }
            };
        }
    }
}

