/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.part.aspect.write.redstone;

import net.minecraft.core.Direction;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneConfig;
import org.cyclops.integrateddynamics.capability.dynamicredstone.DynamicRedstoneHolderGlobal;
import org.cyclops.integrateddynamics.part.aspect.write.redstone.IWriteRedstoneComponent;

public class WriteRedstoneComponent
implements IWriteRedstoneComponent {
    public IDynamicRedstone getGlobalDynamicRedstone(PartTarget target) {
        DimPos dimPos = target.getTarget().getPos();
        Direction side = target.getTarget().getSide();
        return DynamicRedstoneHolderGlobal.getInstance().getDynamicRedstone(dimPos.withPosition(dimPos.getBlockPos().m_121945_(side)), side);
    }

    @Override
    public void setRedstoneLevel(PartTarget target, int level, boolean strongPower) {
        if (target.isDefaultTarget()) {
            DimPos dimPos = target.getCenter().getPos();
            this.getDynamicRedstoneBlock(dimPos, target.getCenter().getSide()).ifPresent(block -> block.setRedstoneLevel(level, strongPower));
        } else {
            this.getGlobalDynamicRedstone(target).setRedstoneLevel(level, strongPower);
        }
    }

    @Override
    public void setLastPulseValue(PartTarget target, int value) {
        DimPos dimPos = target.getCenter().getPos();
        this.getDynamicRedstoneBlock(dimPos, target.getCenter().getSide()).ifPresent(block -> block.setLastPulseValue(value));
    }

    @Override
    public int getLastPulseValue(PartTarget target) {
        DimPos dimPos = target.getCenter().getPos();
        return this.getDynamicRedstoneBlock(dimPos, target.getCenter().getSide()).map(block -> block.getLastPulseValue()).orElse(0);
    }

    @Override
    public void deactivate(PartTarget target) {
        if (target.isDefaultTarget()) {
            DimPos dimPos = target.getCenter().getPos();
            this.getDynamicRedstoneBlock(dimPos, target.getCenter().getSide()).ifPresent(block -> block.setRedstoneLevel(-1, block.isDirect()));
        } else {
            IDynamicRedstone block2 = this.getGlobalDynamicRedstone(target);
            block2.setRedstoneLevel(-1, block2.isDirect());
        }
    }

    @Override
    public LazyOptional<IDynamicRedstone> getDynamicRedstoneBlock(DimPos dimPos, Direction side) {
        return BlockEntityHelpers.getCapability((DimPos)dimPos, (Direction)side, DynamicRedstoneConfig.CAPABILITY);
    }
}

