/*
 * Decompiled with CFR 0.152.
 */
package tfar.unstabletools.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import tfar.unstabletools.UnstableTools;
import tfar.unstabletools.crafting.ConversionManager;
import tfar.unstabletools.crafting.ConversionRecipe;
import tfar.unstabletools.init.ModItems;
import tfar.unstabletools.integration.ConversionRecipeCategory;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private IRecipeCategory<ConversionRecipe> conversionCategory;
    public static final ResourceLocation BLOCK_CONVERSIONS = new ResourceLocation("unstabletools", "block_conversions");
    public static final RecipeType<ConversionRecipe> TYPE = RecipeType.create((String)BLOCK_CONVERSIONS.m_135827_(), (String)BLOCK_CONVERSIONS.m_135815_(), ConversionRecipe.class);

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.unstable_hoe), new RecipeType[]{TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.conversionCategory = new ConversionRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.conversionCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(TYPE, JEIPlugin.getRecipes());
    }

    public static List<ConversionRecipe> getRecipes() {
        ConversionManager conversionManager = UnstableTools.instance.manager;
        ArrayList<ConversionRecipe> conversionRecipes = new ArrayList<ConversionRecipe>();
        for (Map.Entry<Block, Block> entry : conversionManager.getConversionMap().entrySet()) {
            conversionRecipes.add(new ConversionRecipe(entry.getKey(), entry.getValue()));
        }
        return conversionRecipes;
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("unstabletools", "unstabletools");
    }
}

