/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.image;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.konkrete.rendering.RenderUtils;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation MISSING = TextureManager.f_118466_;
    @Nullable
    public ResourceSupplier<ITexture> textureSupplier;
    public boolean repeat = false;
    public boolean nineSlice = false;
    public int nineSliceBorderX = 5;
    public int nineSliceBorderY = 5;

    public ImageElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
    }

    @Override
    public void m_6305_(@NotNull PoseStack pose, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.opacity);
            ITexture t = this.getTextureResource();
            if (t != null && t.isReady()) {
                ResourceLocation loc = t.getResourceLocation();
                if (loc != null) {
                    RenderUtils.bindTexture((ResourceLocation)loc);
                    if (this.repeat) {
                        RenderingUtils.blitRepeat(pose, x, y, this.getAbsoluteWidth(), this.getAbsoluteHeight(), t.getWidth(), t.getHeight());
                    } else if (this.nineSlice) {
                        RenderingUtils.blitNineSliced(pose, x, y, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.nineSliceBorderX, this.nineSliceBorderY, this.nineSliceBorderX, this.nineSliceBorderY, t.getWidth(), t.getHeight(), 0, 0, t.getWidth(), t.getHeight());
                    } else {
                        ImageElement.m_93133_((PoseStack)pose, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.getAbsoluteWidth(), (int)this.getAbsoluteHeight(), (int)this.getAbsoluteWidth(), (int)this.getAbsoluteHeight());
                    }
                }
            } else if (ImageElement.isEditor()) {
                RenderingUtils.renderMissing(pose, this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight());
            }
            RenderingUtils.resetShaderColor();
            RenderSystem.m_69461_();
        }
    }

    @Nullable
    public ITexture getTextureResource() {
        if (this.textureSupplier != null) {
            return this.textureSupplier.get();
        }
        return null;
    }

    public void restoreAspectRatio() {
        ITexture t = this.getTextureResource();
        AspectRatio ratio = t != null ? t.getAspectRatio() : new AspectRatio(10, 10);
        this.baseWidth = ratio.getAspectRatioWidth(this.getAbsoluteHeight());
    }
}

