/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.requirements.system;

import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorFormattingRule;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import org.jetbrains.annotations.NotNull;

public class FileExistsRequirement
extends LoadingRequirement {
    public FileExistsRequirement() {
        super("fancymenu_loading_requirement_file_exists");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isRequirementMet(@Nullable String value) {
        if (value != null) {
            return new File(value).exists();
        }
        return false;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.m_118938_((String)"fancymenu.helper.editor.items.loadingrequirement.file_exists", (Object[])new Object[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(LocalizationUtils.splitLocalizedStringLines("fancymenu.helper.editor.items.loadingrequirement.file_exists.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.m_118938_((String)"fancymenu.editor.loading_requirement.category.system", (Object[])new Object[0]);
    }

    @Override
    public String getValueDisplayName() {
        return I18n.m_118938_((String)"fancymenu.helper.editor.items.loadingrequirement.file_exists.value_name", (Object[])new Object[0]);
    }

    @Override
    public String getValuePreset() {
        return "path/to/file_or_folder";
    }

    @Override
    public List<TextEditorFormattingRule> getValueFormattingRules() {
        return null;
    }
}

