/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.widget;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.UniversalScreenIdentifierRegistry;
import de.keksuccino.fancymenu.customization.widget.ScreenWidgetDiscoverer;
import de.keksuccino.fancymenu.customization.widget.WidgetMeta;
import de.keksuccino.fancymenu.customization.widget.identification.WidgetIdentifierHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetLocatorHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final Map<String, ScreenWidgetCollection> CACHED_WIDGETS = new HashMap<String, ScreenWidgetCollection>();

    protected static void tryCache(@NotNull String screenIdentifier, boolean overrideCache) {
        Screen instance = ScreenInstanceFactory.tryConstruct(screenIdentifier);
        if (instance != null) {
            instance.m_6575_(Minecraft.m_91087_(), 1000, 1000);
            WidgetLocatorHandler.tryCache(instance, overrideCache);
        } else {
            LOGGER.error("[FANCYMENU] WidgetLocatorHandler failed to construct instance of '" + screenIdentifier + "'! Unable to cache widgets!");
        }
    }

    protected static void tryCache(@NotNull Screen screen, boolean overrideCache) {
        if (ScreenCustomization.isScreenBlacklisted(screen)) {
            return;
        }
        String screenIdentifier = ScreenIdentifierHandler.getIdentifierOfScreen(screen);
        if (UniversalScreenIdentifierRegistry.universalIdentifierExists(screenIdentifier)) {
            screenIdentifier = Objects.requireNonNull(UniversalScreenIdentifierRegistry.getScreenForUniversalIdentifier(screenIdentifier));
        }
        if (!CACHED_WIDGETS.containsKey(screenIdentifier) || overrideCache) {
            Screen current = Minecraft.m_91087_().f_91080_;
            if (current == screen) {
                if (!ScreenCustomization.isCustomizationEnabledForScreen(current)) {
                    return;
                }
                ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(current);
                if (layer != null) {
                    ScreenWidgetCollection collection = new ScreenWidgetCollection();
                    collection.setWidgets(layer.cachedScreenWidgetMetas);
                    CACHED_WIDGETS.put(screenIdentifier, collection);
                } else {
                    LOGGER.error("[FANCYMENU] WidgetLocatorHandler failed to cache widgets of current screen '" + screenIdentifier + "'! Customization layer was NULL!");
                }
            } else {
                ScreenWidgetCollection collection = new ScreenWidgetCollection();
                collection.setWidgets(ScreenWidgetDiscoverer.getWidgetsOfScreen(screen, false, false));
                CACHED_WIDGETS.put(screenIdentifier, collection);
            }
        }
    }

    @Nullable
    public static WidgetMeta getWidget(@NotNull String widgetLocator) {
        if (widgetLocator.contains(":")) {
            ScreenWidgetCollection collection;
            String screenIdentifier = widgetLocator.split(":", 2)[0];
            if (UniversalScreenIdentifierRegistry.universalIdentifierExists(screenIdentifier)) {
                screenIdentifier = Objects.requireNonNull(UniversalScreenIdentifierRegistry.getScreenForUniversalIdentifier(screenIdentifier));
            }
            screenIdentifier = ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(screenIdentifier);
            String widgetIdentifier = widgetLocator.split(":", 2)[1];
            Screen current = Minecraft.m_91087_().f_91080_;
            if (current != null && ScreenIdentifierHandler.isIdentifierOfScreen(screenIdentifier, current)) {
                ScreenCustomizationLayer layer;
                if (ScreenCustomization.isCustomizationEnabledForScreen(current) && (layer = ScreenCustomizationLayerHandler.getLayerOfScreen(current)) != null) {
                    if (!CACHED_WIDGETS.containsKey(screenIdentifier)) {
                        WidgetLocatorHandler.tryCache(current, false);
                    }
                    for (WidgetMeta meta : layer.cachedScreenWidgetMetas) {
                        if (!WidgetIdentifierHandler.isIdentifierOfWidget(widgetIdentifier, meta)) continue;
                        return meta;
                    }
                }
            } else if (!CACHED_WIDGETS.containsKey(screenIdentifier)) {
                WidgetLocatorHandler.tryCache(screenIdentifier, false);
            }
            if ((collection = CACHED_WIDGETS.get(screenIdentifier)) != null) {
                return collection.getWidget(widgetIdentifier);
            }
        }
        return null;
    }

    public static boolean invokeWidgetOnClick(@NotNull String widgetLocator) {
        WidgetMeta meta = WidgetLocatorHandler.getWidget(widgetLocator);
        if (meta != null) {
            return WidgetLocatorHandler.invokeWidgetOnClick(meta);
        }
        return false;
    }

    public static boolean invokeWidgetOnClick(@NotNull WidgetMeta meta) {
        try {
            AbstractWidget w = meta.getWidget();
            w.m_5716_((double)(w.f_93620_ + 1), (double)(w.f_93621_ + 1));
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to invoke widget's onClick() method!", (Throwable)ex);
            LOGGER.error("[FANCYMENU] WidgetLocatorHandler failed to invoke widget onClick!");
            return false;
        }
    }

    public static void clearCache() {
        CACHED_WIDGETS.clear();
    }

    protected static class ScreenWidgetCollection {
        @NotNull
        protected List<WidgetMeta> widgets = new ArrayList<WidgetMeta>();

        protected ScreenWidgetCollection() {
        }

        protected void setWidgets(@NotNull List<WidgetMeta> metas) {
            this.widgets = metas;
        }

        @NotNull
        protected List<WidgetMeta> getWidgets() {
            return this.widgets;
        }

        @Nullable
        protected WidgetMeta getWidget(@NotNull String widgetIdentifier) {
            for (WidgetMeta meta : this.widgets) {
                if (!WidgetIdentifierHandler.isIdentifierOfWidget(widgetIdentifier, meta)) continue;
                return meta;
            }
            return null;
        }
    }
}

