/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.Nullable;

public interface Resource
extends Closeable {
    @Nullable
    public InputStream open() throws IOException;

    public boolean isReady();

    public boolean isLoadingCompleted();

    public boolean isLoadingFailed();

    default public void waitForReady(long timeoutMs) {
        long start = System.currentTimeMillis();
        while (!this.isReady() && start + timeoutMs > System.currentTimeMillis()) {
        }
    }

    default public void waitForLoadingCompletedOrFailed(long timeoutMs) {
        long start = System.currentTimeMillis();
        while (!this.isLoadingCompleted() && !this.isLoadingFailed() && start + timeoutMs > System.currentTimeMillis()) {
        }
    }

    public boolean isClosed();
}

