/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.player.Player;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.PageLabelButton;
import sonar.fluxnetworks.common.connection.FluxMenu;

public abstract class GuiTabPages<T>
extends GuiTabCore {
    public final List<T> mElements = new ArrayList<T>();
    protected final List<T> mCurrent = new ArrayList<T>();
    protected SortType mSortType = SortType.ID;
    protected PageLabelButton mLabelButton;
    public int mPage = 0;
    public int mPages = 1;
    public int mGridStartX = 0;
    public int mGridStartY = 0;
    public int mGridHeight = 0;
    public int mGridPerPage = 1;
    public int mElementWidth = 0;
    public int mElementHeight = 0;

    public GuiTabPages(@Nonnull FluxMenu menu, @Nonnull Player player) {
        super(menu, player);
    }

    @Override
    protected void drawForegroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY, deltaTicks);
        if (this.mPages > 1) {
            this.mLabelButton.drawButton(poseStack, mouseX, mouseY, deltaTicks);
        }
        for (int i = 0; i < this.mCurrent.size(); ++i) {
            int y = this.mGridStartY + this.mGridHeight * i;
            this.renderElement(poseStack, this.mCurrent.get(i), this.mGridStartX, y);
        }
        T hovered = this.getHoveredElement(mouseX, mouseY);
        if (hovered != null && this.getCurrentPopup() == null) {
            this.renderElementTooltip(poseStack, hovered, mouseX, mouseY);
        }
    }

    @Override
    protected void drawBackgroundLayer(PoseStack poseStack, int mouseX, int mouseY, float deltaTicks) {
        super.drawBackgroundLayer(poseStack, mouseX, mouseY, deltaTicks);
    }

    @Nullable
    public T getHoveredElement(double mouseX, double mouseY) {
        if (this.mCurrent.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.mCurrent.size(); ++i) {
            int y = this.mGridStartY + this.mGridHeight * i;
            if (!(mouseX >= (double)this.mGridStartX) || !(mouseY >= (double)y) || !(mouseX < (double)(this.mGridStartX + this.mElementWidth)) || !(mouseY < (double)(y + this.mElementHeight))) continue;
            return this.mCurrent.get(i);
        }
        return null;
    }

    @Override
    public boolean onMouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (super.onMouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        T hovered = this.getHoveredElement(mouseX, mouseY);
        if (hovered != null) {
            this.onElementClicked(hovered, mouseButton);
            return true;
        }
        if (this.mPages > 1 && this.mLabelButton.isMouseHovered(mouseX, mouseY) && this.mLabelButton.mHoveredPage != -1 && this.mPage != this.mLabelButton.mHoveredPage) {
            this.mPage = this.mLabelButton.mHoveredPage;
            this.refreshCurrentPage();
            return true;
        }
        return false;
    }

    protected abstract void onElementClicked(T var1, int var2);

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.mLabelButton = new PageLabelButton(this, this.f_97735_ + 14, this.f_97736_ + 157, 148, 4, this.mPage, this.mPages, this.getNetwork().getNetworkColor());
    }

    @Override
    public boolean onMouseScrolled(double mouseX, double mouseY, double vScroll) {
        if (vScroll < 0.0 && this.mPage < this.mPages - 1) {
            ++this.mPage;
            this.refreshCurrentPage();
            return true;
        }
        if (vScroll > 0.0 && this.mPage > 0) {
            --this.mPage;
            this.refreshCurrentPage();
            return true;
        }
        return super.onMouseScrolled(mouseX, mouseY, vScroll);
    }

    public abstract void renderElement(PoseStack var1, T var2, int var3, int var4);

    public abstract void renderElementTooltip(PoseStack var1, T var2, int var3, int var4);

    protected void refreshPages(Collection<T> elements) {
        this.mElements.clear();
        this.mElements.addAll(elements);
        this.mPages = elements.isEmpty() ? 1 : (int)Math.ceil((double)elements.size() / (double)this.mGridPerPage);
        this.mPage = Math.min(this.mPage, this.mPages - 1);
        this.sortGrids(this.mSortType);
        this.refreshCurrentPage();
    }

    protected void refreshCurrentPage() {
        this.mPage = Math.min(this.mPage, this.mPages - 1);
        this.mLabelButton.refreshPages(this.mPage, this.mPages);
        if (this.mElements.isEmpty()) {
            return;
        }
        this.mCurrent.clear();
        int start = this.mPage * this.mGridPerPage;
        int end = Math.min(this.mElements.size(), start + this.mGridPerPage);
        for (int i = start; i < end; ++i) {
            this.mCurrent.add(this.mElements.get(i));
        }
    }

    protected void sortGrids(SortType sortType) {
    }

    @Override
    protected void m_181908_() {
        super.m_181908_();
        if (this.mLabelButton != null) {
            this.mLabelButton.mColor = this.getNetwork().getNetworkColor();
        }
    }

    public static enum SortType {
        ID(FluxTranslate.SORTING_ID),
        NAME(FluxTranslate.SORTING_NAME);

        private final FluxTranslate mName;

        private SortType(FluxTranslate name) {
            this.mName = name;
        }

        @Nonnull
        public String getTranslatedName() {
            return this.mName.get();
        }
    }
}

