/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.energy;

import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.base.EnergySnapshot;
import earth.terrarium.botarium.common.energy.impl.SimpleEnergySnapshot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public record PlatformBlockEnergyManager(IEnergyStorage energy) implements EnergyContainer
{
    public static PlatformBlockEnergyManager of(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        BlockEntity provider;
        BlockEntity blockEntity = provider = entity != null ? entity : level.m_7702_(pos);
        if (provider == null) {
            return null;
        }
        LazyOptional cap = provider.getCapability(ForgeCapabilities.ENERGY, direction);
        return cap.map(PlatformBlockEnergyManager::new).orElse(null);
    }

    @Override
    public long insertEnergy(long maxAmount, boolean simulate) {
        return this.energy.receiveEnergy((int)maxAmount, simulate);
    }

    @Override
    public long extractEnergy(long maxAmount, boolean simulate) {
        return this.energy.extractEnergy((int)maxAmount, simulate);
    }

    @Override
    public void setEnergy(long energy) {
        if (energy > (long)this.energy.getEnergyStored()) {
            this.energy.receiveEnergy((int)(energy - (long)this.energy.getEnergyStored()), false);
        } else if (energy < (long)this.energy.getEnergyStored()) {
            this.energy.extractEnergy((int)((long)this.energy.getEnergyStored() - energy), false);
        }
    }

    @Override
    public long getStoredEnergy() {
        return this.energy.getEnergyStored();
    }

    @Override
    public long getMaxCapacity() {
        return this.energy.getMaxEnergyStored();
    }

    @Override
    public long maxInsert() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long maxExtract() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean allowsInsertion() {
        return this.energy.canReceive();
    }

    @Override
    public boolean allowsExtraction() {
        return this.energy.canExtract();
    }

    @Override
    public EnergySnapshot createSnapshot() {
        return new SimpleEnergySnapshot(this);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
    }

    @Override
    public CompoundTag serialize(CompoundTag nbt) {
        return nbt;
    }

    public void m_6211_() {
        this.setEnergy(0L);
    }
}

