/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.trades;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.TradeUtil;

public class MyTradeEffect {
    public String effectKey;
    public Integer duration;
    public Integer level;
    public Boolean isVisible;
    public String potionKey;
    public String[] blacklistedPotionKeys;

    public MyTradeEffect() {
        if (this.duration == null) {
            this.duration = 300;
        }
        if (this.level == null) {
            this.level = 1;
        }
        if (this.isVisible == null) {
            this.isVisible = true;
        }
        if (this.potionKey == null) {
            this.potionKey = "minecraft:empty";
        }
    }

    public Potion getPotionKey(String key) {
        return TradeUtil.getPotionFromKey(key);
    }

    public MobEffect getEffect(String key) {
        return TradeUtil.getEffectFromKey(key);
    }

    public MobEffectInstance getInstance() {
        int actualLevel = this.level - 1;
        if (actualLevel < 0) {
            actualLevel = 0;
        }
        return new MobEffectInstance(this.getEffect(this.effectKey), this.duration.intValue(), actualLevel, false, this.isVisible.booleanValue(), this.isVisible.booleanValue());
    }

    public MobEffectInstance getInstance(String chosenKey) {
        int actualLevel = this.level - 1;
        if (actualLevel < 0) {
            actualLevel = 0;
        }
        return new MobEffectInstance(this.getEffect(chosenKey), this.duration.intValue(), actualLevel, false, this.isVisible.booleanValue(), this.isVisible.booleanValue());
    }

    public boolean validate(String profession, int tradeEntry, String itemKey, boolean forPotion) {
        boolean isValid = true;
        if (this.effectKey == null || this.effectKey == "") {
            ModLogger.warn("Unable to add a custom trade! Reason: the effect key has not been defined - profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
            isValid = false;
        } else if (forPotion) {
            if (!TradeUtil.checkPotionKey(itemKey)) {
                ModLogger.warn("Unable to add a custom trade! Reason: potion effect invalid - " + this.effectKey + ", profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
                isValid = false;
            }
            if (this.blacklistedPotionKeys != null) {
                for (int i = 0; i < this.blacklistedPotionKeys.length; ++i) {
                    if (TradeUtil.checkPotionKey(this.blacklistedPotionKeys[i])) continue;
                    ModLogger.warn("Unable to add a custom trade! Reason: blacklisted potion key invalid - " + this.blacklistedPotionKeys[i] + ", profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
                    isValid = false;
                }
            }
        } else if (!TradeUtil.checkEffectKey(this.effectKey)) {
            ModLogger.warn("Unable to add a custom trade! Reason: effect invalid - " + this.effectKey + ", profession = " + profession + ", entry number = " + tradeEntry + ", item = " + itemKey);
            isValid = false;
        }
        return isValid;
    }
}

