/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.trades;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import uk.co.dotcode.customvillagertrades.ModLogger;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.trades.MyTradeEffect;
import uk.co.dotcode.customvillagertrades.trades.MyTradeEnchantment;
import uk.co.dotcode.customvillagertrades.trades.NBTData;

public class MyTradeItem {
    public String itemKey;
    public String customName;
    public Integer amount;
    public Integer amountRange;
    public Integer priceModifier;
    public Integer priceModifierAdditional;
    public Integer customColourR;
    public Integer customColourG;
    public Integer customColourB;
    public Integer metadata;
    public MyTradeEnchantment[] enchantments;
    public MyTradeEnchantment[] semiRandomEnchantments;
    public String[] blacklistedEnchantments;
    public MyTradeEffect[] effects;
    public String[] blacklistedEffects;
    public NBTData[] nbtTags;
    public String advancedNBTData;
    public String mapStructure;

    public MyTradeItem(String itemKey, int amount, int priceModifier) {
        this.itemKey = itemKey;
        this.amount = amount;
        this.priceModifier = priceModifier;
    }

    public int getPriceModifier() {
        if (this.priceModifier == null) {
            return 0;
        }
        return this.priceModifier;
    }

    public int getPriceModifierAdditional() {
        if (this.priceModifierAdditional == null) {
            return 0;
        }
        return this.priceModifierAdditional;
    }

    public boolean validate(String profession, int tradeEntry) {
        int i;
        boolean isValid = true;
        if (!TradeUtil.checkItemKey(this.itemKey)) {
            ModLogger.warn("Unable to add a custom trade! Reason: invalid item - " + profession + ", entry number = " + tradeEntry + ", item = " + this.itemKey);
            isValid = false;
        }
        if (this.amountRange != null && this.amountRange < 1) {
            ModLogger.warn("Unable to add a custom trade! Reason: amountRange is less than 1 - " + profession + ", entry number = " + tradeEntry + ", item = " + this.itemKey);
            isValid = false;
        }
        if (this.enchantments != null) {
            for (i = 0; i < this.enchantments.length; ++i) {
                if (this.enchantments[i].validate(profession, tradeEntry, this.itemKey)) continue;
                isValid = false;
            }
        }
        if (this.semiRandomEnchantments != null) {
            for (i = 0; i < this.semiRandomEnchantments.length; ++i) {
                if (this.semiRandomEnchantments[i].validate(profession, tradeEntry, this.itemKey)) continue;
                isValid = false;
            }
        }
        if (this.blacklistedEnchantments != null) {
            for (i = 0; i < this.blacklistedEnchantments.length; ++i) {
                if (TradeUtil.checkEnchantmentKey(this.blacklistedEnchantments[i])) continue;
                ModLogger.warn("Unable to add a custom trade! Reason: blacklisted enchantment invalid - " + this.blacklistedEnchantments[i] + ", profession = " + profession + ", entry number = " + tradeEntry + ", item = " + this.itemKey);
                isValid = false;
            }
        }
        if (this.effects != null) {
            if (this.itemKey == "minecraft:tipped_arrow") {
                if (this.effects.length < 1) {
                    ModLogger.warn("Unable to add a custom trade! Reason: you need to define one effect for the tipped arrow " + this.itemKey + ", profession = " + profession + ", entry number = " + tradeEntry + ", item = " + this.itemKey);
                    isValid = false;
                } else {
                    this.effects[0].validate(profession, tradeEntry, profession, isValid);
                }
            } else {
                for (i = 0; i < this.effects.length; ++i) {
                    this.effects[i].validate(profession, tradeEntry, profession, false);
                }
            }
        }
        return isValid;
    }

    public ItemStack createItemStack(int modifier, Entity entity) {
        Item item = TradeUtil.getItemFromKey(this.itemKey);
        ItemStack stack = new ItemStack((ItemLike)item, this.getAmount() + modifier);
        stack = this.processOther(stack, entity);
        if (this.metadata != null) {
            stack.m_41721_(this.metadata.intValue());
        }
        if (this.customName != null) {
            stack.m_41714_((Component)Component.m_237113_((String)this.customName));
        }
        stack = this.processEnchantments(stack);
        this.processCustomColour(stack);
        if (!this.itemKey.equalsIgnoreCase("minecraft:tipped_arrow")) {
            stack = this.processEffects(stack, entity);
        }
        if (!this.itemKey.equalsIgnoreCase("minecraft:potion")) {
            stack = this.processNBTData(stack);
        }
        return stack;
    }

    private void processCustomColour(ItemStack stack) {
        if (this.itemKey.equalsIgnoreCase("minecraft:tipped_arrow") || this.itemKey.equalsIgnoreCase("minecraft:potion")) {
            if (this.customColourR == null) {
                this.customColourR = 255;
            }
            if (this.customColourG == null) {
                this.customColourG = 0;
            }
            if (this.customColourB == null) {
                this.customColourB = 255;
            }
            NBTData colourNBT = new NBTData();
            colourNBT.nbtName = "CustomPotionColor";
            colourNBT.dataType = "Integer";
            colourNBT.data = Integer.toString(TradeUtil.getIntFromColor(this.customColourR, this.customColourG, this.customColourB));
            stack.m_41784_().m_128391_(colourNBT.getTag());
        }
    }

    private ItemStack processOther(ItemStack stack, Entity entity) {
        ItemStack modifiedStack = stack.m_41777_();
        if (stack.m_41720_() == Items.f_42573_ && this.mapStructure != null) {
            ModLogger.warn("Maps are not supported in this version of Custom Villager Trades. This is because there has been changes to how they work and Forge has not yet fully integrated with it.");
        }
        if (stack.m_41720_() == Items.f_42738_) {
            Potion selectedPotion = null;
            ItemStack potionStack = stack.m_41777_();
            if (this.effects[0].potionKey.equalsIgnoreCase("random")) {
                ArrayList<Potion> possiblePotions = new ArrayList<Potion>();
                List<Potion> list = TradeUtil.getRegisteredPotions();
                for (Potion p : list) {
                    boolean blacklisted = false;
                    if (this.effects[0].blacklistedPotionKeys != null) {
                        for (String blacklistString : this.effects[0].blacklistedPotionKeys) {
                            if (!TradeUtil.getPotionKey(p).toString().equalsIgnoreCase(blacklistString) && !TradeUtil.getPotionKey(p).toString().equalsIgnoreCase("minecraft:awkward") && !TradeUtil.getPotionKey(p).toString().equalsIgnoreCase("minecraft:empty") && !TradeUtil.getPotionKey(p).toString().equalsIgnoreCase("minecraft:mundane")) continue;
                            blacklisted = true;
                        }
                    }
                    if (blacklisted) continue;
                    possiblePotions.add(p);
                }
                int random = TradeUtil.random.nextInt(possiblePotions.size());
                selectedPotion = (Potion)possiblePotions.get(random);
            } else {
                for (Potion p : TradeUtil.getRegisteredPotions()) {
                    if (!TradeUtil.getPotionKey(p).toString().equalsIgnoreCase(this.effects[0].potionKey)) continue;
                    selectedPotion = p;
                    break;
                }
            }
            if (selectedPotion != null) {
                PotionUtils.m_43549_((ItemStack)potionStack, selectedPotion);
                modifiedStack = potionStack;
            }
        }
        return modifiedStack;
    }

    private ItemStack processEnchantments(ItemStack stack) {
        ItemStack enchantedStack = stack.m_41777_();
        if (this.enchantments != null) {
            for (int i = 0; i < this.enchantments.length; ++i) {
                if (this.enchantments[i].enchantmentKey.equalsIgnoreCase("random")) {
                    this.addEnchantmentMyWay(enchantedStack, this.generateTrueRandomEnchantment(enchantedStack), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
                    continue;
                }
                if (this.enchantments[i].enchantmentKey.contains("#")) {
                    String[] enchantmentChoices = this.enchantments[i].enchantmentKey.split("#");
                    String chosenKey = enchantmentChoices[TradeUtil.random.nextInt(enchantmentChoices.length)];
                    this.addEnchantmentMyWay(enchantedStack, TradeUtil.getEnchantmentFromKey(chosenKey), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
                    continue;
                }
                this.addEnchantmentMyWay(enchantedStack, this.enchantments[i].getEnchantment(), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
            }
        }
        if (this.semiRandomEnchantments != null) {
            int randomInt = TradeUtil.random.nextInt(this.semiRandomEnchantments.length);
            this.addEnchantmentMyWay(enchantedStack, this.semiRandomEnchantments[randomInt].getEnchantment(), this.semiRandomEnchantments[randomInt].enchantmentLevel, this.semiRandomEnchantments[randomInt].maxEnchantmentLevel);
        }
        return enchantedStack;
    }

    private ItemStack processNBTData(ItemStack stack) {
        ItemStack nbtStack = stack.m_41777_();
        if (this.advancedNBTData != null && !this.advancedNBTData.isEmpty()) {
            try {
                CompoundTag advancedNBT = TagParser.m_129359_((String)this.advancedNBTData);
                nbtStack.m_41784_().m_128391_(advancedNBT);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                ModLogger.warn("There was an error adding an advanced NBT to item: " + this.advancedNBTData);
            }
        }
        if (this.nbtTags != null) {
            for (NBTData nbt : this.nbtTags) {
                nbtStack.m_41784_().m_128391_(nbt.getTag());
            }
        }
        return nbtStack;
    }

    private ItemStack processEffects(ItemStack stack, Entity entity) {
        ItemStack effectStack = stack.m_41777_();
        if (this.effects != null) {
            ArrayList<MobEffectInstance> effectsToApply = new ArrayList<MobEffectInstance>();
            for (int i = 0; i < this.effects.length; ++i) {
                if (this.effects[i].effectKey.equalsIgnoreCase("random")) {
                    ArrayList<MobEffectInstance> availableRandomEffects = new ArrayList<MobEffectInstance>();
                    for (MobEffect e : TradeUtil.getRegisteredMobEffects()) {
                        boolean isBlacklisted = false;
                        if (this.blacklistedEffects != null) {
                            for (String blacklisted : this.blacklistedEffects) {
                                if (!TradeUtil.getRegistryNameEffect(e).toString().equalsIgnoreCase(blacklisted)) continue;
                                isBlacklisted = true;
                            }
                        }
                        if (isBlacklisted) continue;
                        availableRandomEffects.add(this.effects[i].getInstance(TradeUtil.getRegistryNameEffect(e).toString()));
                    }
                    if (availableRandomEffects.size() <= 0) continue;
                    effectsToApply.add(new MobEffectInstance((MobEffectInstance)availableRandomEffects.get(TradeUtil.random.nextInt(availableRandomEffects.size()))));
                    continue;
                }
                if (this.effects[i].effectKey.contains("#")) {
                    String[] effectChoices = this.effects[i].effectKey.split("#");
                    String chosenKey = effectChoices[TradeUtil.random.nextInt(effectChoices.length)];
                    effectsToApply.add(this.effects[i].getInstance(chosenKey));
                    continue;
                }
                effectsToApply.add(this.effects[i].getInstance());
            }
            PotionUtils.m_43552_((ItemStack)effectStack, effectsToApply);
            if (this.itemKey.equalsIgnoreCase("minecraft:suspicious_stew")) {
                for (MobEffectInstance e : effectsToApply) {
                    SuspiciousStewItem.m_43258_((ItemStack)effectStack, (MobEffect)e.m_19544_(), (int)e.m_19557_());
                }
            }
        }
        return effectStack;
    }

    private ItemStack addEnchantmentMyWay(ItemStack stack, Enchantment enchantment, int level, int maxLevel) {
        int chosenLevel = level;
        if (level < 0) {
            chosenLevel = TradeUtil.random.nextInt(maxLevel) + 1;
        }
        if (stack.m_41720_() == Items.f_42690_) {
            EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(enchantment, chosenLevel));
        } else {
            stack.m_41663_(enchantment, chosenLevel);
        }
        return stack;
    }

    private Enchantment generateTrueRandomEnchantment(ItemStack stack) {
        ArrayList<Enchantment> availableRandomEnchantments = new ArrayList<Enchantment>();
        for (Enchantment e : TradeUtil.getRegisteredEnchantments()) {
            boolean isBlacklisted = false;
            if (TradeUtil.getRegistryNameItem(stack.m_41720_()).toString().equalsIgnoreCase("minecraft:enchanted_book")) {
                if (this.blacklistedEnchantments != null) {
                    for (String blacklisted : this.blacklistedEnchantments) {
                        if (!TradeUtil.getRegistryNameEnchantment(e).toString().equalsIgnoreCase(blacklisted)) continue;
                        isBlacklisted = true;
                    }
                }
                if (isBlacklisted) continue;
                availableRandomEnchantments.add(e);
                continue;
            }
            if (!e.m_6081_(stack)) continue;
            if (this.blacklistedEnchantments != null) {
                for (String blacklisted : this.blacklistedEnchantments) {
                    if (!TradeUtil.getRegistryNameEnchantment(e).toString().equalsIgnoreCase(blacklisted)) continue;
                    isBlacklisted = true;
                }
            }
            if (isBlacklisted) continue;
            availableRandomEnchantments.add(e);
        }
        if (availableRandomEnchantments.size() > 0) {
            Enchantment selectedRandomEnchantment = (Enchantment)availableRandomEnchantments.get(TradeUtil.random.nextInt(availableRandomEnchantments.size()));
            boolean isUnique = false;
            int attemptNumber = 0;
            while (!isUnique) {
                ListTag appliedEnchantments = stack.m_41785_();
                if (stack.m_41720_() == Items.f_42690_) {
                    appliedEnchantments = EnchantedBookItem.m_41163_((ItemStack)stack);
                }
                boolean foundConflict = false;
                for (int j = 0; j < appliedEnchantments.size(); ++j) {
                    CompoundTag entry = appliedEnchantments.m_128728_(j);
                    if (!TradeUtil.getRegistryNameEnchantment(selectedRandomEnchantment).toString().equalsIgnoreCase(entry.m_128461_("id"))) continue;
                    foundConflict = true;
                    selectedRandomEnchantment = (Enchantment)availableRandomEnchantments.get(TradeUtil.random.nextInt(availableRandomEnchantments.size()));
                }
                if (!foundConflict) {
                    isUnique = true;
                } else {
                    ++attemptNumber;
                }
                if (attemptNumber < 3) continue;
                ModLogger.warn("Failed to find a unique enchantment after 3 attempts, stopping to conserve system resources.");
                isUnique = true;
            }
            return selectedRandomEnchantment;
        }
        return null;
    }

    private int getAmount() {
        if (this.amountRange != null && this.amountRange > 0) {
            return TradeUtil.random.nextInt(this.amountRange) + this.amount;
        }
        return this.amount;
    }
}

