/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.laserio.common.network.packets;

import com.direwolf20.laserio.common.blockentities.LaserNodeBE;
import com.direwolf20.laserio.util.ParticleData;
import com.direwolf20.laserio.util.ParticleRenderData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketNodeParticles {
    private List<ParticleData> particleList;

    public PacketNodeParticles(List<ParticleData> particleList) {
        this.particleList = particleList;
    }

    public static void encode(PacketNodeParticles msg, FriendlyByteBuf buffer) {
        List<ParticleData> tempList = msg.particleList;
        int size = tempList.size();
        buffer.writeInt(size);
        for (ParticleData data : tempList) {
            buffer.writeInt(data.item);
            buffer.writeByte((int)data.itemCount);
            if (data.fromData != null) {
                buffer.m_130064_(data.fromData.node());
                buffer.writeByte((int)data.fromData.direction());
                buffer.writeByte((int)data.fromData.position());
            }
            if (data.toData == null) continue;
            buffer.m_130064_(data.toData.node());
            buffer.writeByte((int)data.toData.direction());
            buffer.writeByte((int)data.toData.position());
        }
    }

    public static PacketNodeParticles decode(FriendlyByteBuf buffer) {
        ArrayList<ParticleData> thisList = new ArrayList<ParticleData>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            int item = buffer.readInt();
            byte itemCount = buffer.readByte();
            BlockPos fromNode = buffer.m_130135_();
            byte fromDirection = buffer.readByte();
            byte extractPosition = buffer.readByte();
            BlockPos toNode = buffer.m_130135_();
            byte toDirection = buffer.readByte();
            byte insertPosition = buffer.readByte();
            ParticleData data = new ParticleData(item, itemCount, fromNode, fromDirection, toNode, toDirection, extractPosition, insertPosition);
            thisList.add(data);
        }
        return new PacketNodeParticles(thisList);
    }

    public static void clientPacketHandler(PacketNodeParticles msg) {
        List<ParticleData> tempList = msg.particleList;
        for (ParticleData data : tempList) {
            BlockPos toPos;
            BlockEntity toTE;
            BlockPos fromPos;
            BlockEntity fromTE;
            if (data.fromData != null && (fromTE = Minecraft.m_91087_().f_91073_.m_7702_(fromPos = data.fromData.node())) instanceof LaserNodeBE) {
                ((LaserNodeBE)fromTE).addParticleData(new ParticleRenderData(data.item, data.itemCount, fromPos.m_121945_(Direction.values()[data.fromData.direction()]), data.fromData.direction(), data.fromData.node(), data.fromData.position()));
            }
            if (data.toData == null || !((toTE = Minecraft.m_91087_().f_91073_.m_7702_(toPos = data.toData.node())) instanceof LaserNodeBE)) continue;
            ((LaserNodeBE)toTE).addParticleData(new ParticleRenderData(data.item, data.itemCount, data.toData.node(), data.toData.direction(), toPos.m_121945_(Direction.values()[data.toData.direction()]), data.toData.position()));
        }
    }

    public static class Handler {
        public static void handle(PacketNodeParticles msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketNodeParticles.clientPacketHandler(msg)));
            ctx.get().setPacketHandled(true);
        }
    }
}

