/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.reaper.common.block;

import earth.terrarium.reaper.common.blockentity.ReaperGeneratorBlockEntity;
import earth.terrarium.reaper.common.registry.ReaperRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ReaperGeneratorMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData data;
    private final ReaperGeneratorBlockEntity reaperGenerator;

    public ReaperGeneratorMenu(Container container, ContainerData data, int i, Inventory inventory, ReaperGeneratorBlockEntity reaperGenerator) {
        super(ReaperRegistry.REAPER_GEN_MENU.get(), i);
        int y;
        this.container = container;
        this.data = data;
        this.reaperGenerator = reaperGenerator;
        int slot = 0;
        for (y = 0; y < 4; ++y) {
            this.m_38897_(new CatalystSlot(this.container, this.reaperGenerator, slot, 96, 17 + y * 18));
            ++slot;
        }
        for (y = 0; y < 4; ++y) {
            this.m_38897_(new RuneSlot(this.container, slot, 152, 17 + y * 18));
            ++slot;
        }
        this.addPlayerInvSlots(inventory);
        this.m_38884_(data);
    }

    public ReaperGeneratorMenu(int syncId, Inventory inventory, FriendlyByteBuf buf) {
        this((Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(6), syncId, inventory, (ReaperGeneratorBlockEntity)inventory.f_35978_.f_19853_.m_7702_(buf.m_130135_()));
    }

    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack newStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            newStack = originalStack.m_41777_();
            if (index < 8 ? !this.m_38903_(originalStack, 8, this.f_38839_.size(), true) : !this.m_38903_(originalStack, 0, 8, false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return newStack;
    }

    public Container getContainer() {
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    public ReaperGeneratorBlockEntity getBlockEntity() {
        return this.reaperGenerator;
    }

    public boolean m_6875_(@NotNull Player player) {
        return true;
    }

    protected void addPlayerInvSlots(Inventory inventory) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 104 + y * 18));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 162));
        }
    }

    public static class CatalystSlot
    extends Slot {
        private final ReaperGeneratorBlockEntity reaperGenerator;

        public CatalystSlot(Container container, ReaperGeneratorBlockEntity reaperGenerator, int index, int x, int y) {
            super(container, index, x, y);
            this.reaperGenerator = reaperGenerator;
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_150930_(ReaperRegistry.SOUL_CATALYST.get());
        }

        public boolean m_8010_(@NotNull Player player) {
            return this.reaperGenerator.cooldown > 30;
        }
    }

    public static class RuneSlot
    extends Slot {
        public RuneSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            return stack.m_204117_(ReaperRegistry.RUNES);
        }
    }
}

