/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.DirectionalShaftHalvesBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.chainDrive.ChainDriveBlock;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlock;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class RotationPropagator {
    private static final int MAX_FLICKER_SCORE = 128;

    private static float getRotationSpeedModifier(KineticBlockEntity from, KineticBlockEntity to) {
        boolean connectedByGears;
        BlockState stateFrom = from.m_58900_();
        BlockState stateTo = to.m_58900_();
        Block fromBlock = stateFrom.m_60734_();
        Block toBlock = stateTo.m_60734_();
        if (!(fromBlock instanceof IRotate) || !(toBlock instanceof IRotate)) {
            return 0.0f;
        }
        IRotate definitionFrom = (IRotate)fromBlock;
        IRotate definitionTo = (IRotate)toBlock;
        BlockPos diff = to.m_58899_().m_121996_((Vec3i)from.m_58899_());
        Direction direction = Direction.m_122372_((float)diff.m_123341_(), (float)diff.m_123342_(), (float)diff.m_123343_());
        Level world = from.m_58904_();
        boolean alignedAxes = true;
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (axis == direction.m_122434_() || axis.m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_()) == 0) continue;
            alignedAxes = false;
        }
        boolean connectedByAxis = alignedAxes && definitionFrom.hasShaftTowards((LevelReader)world, from.m_58899_(), stateFrom, direction) && definitionTo.hasShaftTowards((LevelReader)world, to.m_58899_(), stateTo, direction.m_122424_());
        float custom = from.propagateRotationTo(to, stateFrom, stateTo, diff, connectedByAxis, connectedByGears = ICogWheel.isSmallCog(stateFrom) && ICogWheel.isSmallCog(stateTo));
        if (custom != 0.0f) {
            return custom;
        }
        if (connectedByAxis) {
            float axisModifier = RotationPropagator.getAxisModifier(to, direction.m_122424_());
            if (axisModifier != 0.0f) {
                axisModifier = 1.0f / axisModifier;
            }
            return RotationPropagator.getAxisModifier(from, direction) * axisModifier;
        }
        if (fromBlock instanceof ChainDriveBlock && toBlock instanceof ChainDriveBlock) {
            boolean connected = ChainDriveBlock.areBlocksConnected(stateFrom, stateTo, direction);
            return connected ? ChainDriveBlock.getRotationSpeedModifier(from, to) : 0.0f;
        }
        if (RotationPropagator.isLargeToLargeGear(stateFrom, stateTo, diff)) {
            Direction.Axis sourceAxis = (Direction.Axis)stateFrom.m_61143_((Property)BlockStateProperties.f_61365_);
            Direction.Axis targetAxis = (Direction.Axis)stateTo.m_61143_((Property)BlockStateProperties.f_61365_);
            int sourceAxisDiff = sourceAxis.m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
            int targetAxisDiff = targetAxis.m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
            return sourceAxisDiff > 0 ^ targetAxisDiff > 0 ? -1.0f : 1.0f;
        }
        if (ICogWheel.isLargeCog(stateFrom) && ICogWheel.isSmallCog(stateTo) && RotationPropagator.isLargeToSmallCog(stateFrom, stateTo, definitionTo, diff)) {
            return -2.0f;
        }
        if (ICogWheel.isLargeCog(stateTo) && ICogWheel.isSmallCog(stateFrom) && RotationPropagator.isLargeToSmallCog(stateTo, stateFrom, definitionFrom, diff)) {
            return -0.5f;
        }
        if (connectedByGears) {
            if (diff.m_123333_((Vec3i)BlockPos.f_121853_) != 1) {
                return 0.0f;
            }
            if (ICogWheel.isLargeCog(stateTo)) {
                return 0.0f;
            }
            if (direction.m_122434_() == definitionFrom.getRotationAxis(stateFrom)) {
                return 0.0f;
            }
            if (definitionFrom.getRotationAxis(stateFrom) == definitionTo.getRotationAxis(stateTo)) {
                return -1.0f;
            }
        }
        return 0.0f;
    }

    private static float getConveyedSpeed(KineticBlockEntity from, KineticBlockEntity to) {
        BlockState stateTo;
        BlockState stateFrom = from.m_58900_();
        if (RotationPropagator.isLargeCogToSpeedController(stateFrom, stateTo = to.m_58900_(), to.m_58899_().m_121996_((Vec3i)from.m_58899_()))) {
            return SpeedControllerBlockEntity.getConveyedSpeed(from, to, true);
        }
        if (RotationPropagator.isLargeCogToSpeedController(stateTo, stateFrom, from.m_58899_().m_121996_((Vec3i)to.m_58899_()))) {
            return SpeedControllerBlockEntity.getConveyedSpeed(to, from, false);
        }
        float rotationSpeedModifier = RotationPropagator.getRotationSpeedModifier(from, to);
        return from.getTheoreticalSpeed() * rotationSpeedModifier;
    }

    private static boolean isLargeToLargeGear(BlockState from, BlockState to, BlockPos diff) {
        Direction.Axis toAxis;
        if (!ICogWheel.isLargeCog(from) || !ICogWheel.isLargeCog(to)) {
            return false;
        }
        Direction.Axis fromAxis = (Direction.Axis)from.m_61143_((Property)BlockStateProperties.f_61365_);
        if (fromAxis == (toAxis = (Direction.Axis)to.m_61143_((Property)BlockStateProperties.f_61365_))) {
            return false;
        }
        for (Direction.Axis axis : Direction.Axis.values()) {
            int axisDiff = axis.m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_());
            if (!(axis == fromAxis || axis == toAxis ? axisDiff == 0 : axisDiff != 0)) continue;
            return false;
        }
        return true;
    }

    private static float getAxisModifier(KineticBlockEntity be, Direction direction) {
        if (!be.hasSource() && !be.isSource() || !(be instanceof DirectionalShaftHalvesBlockEntity)) {
            return 1.0f;
        }
        Direction source = ((DirectionalShaftHalvesBlockEntity)be).getSourceFacing();
        if (be instanceof GearboxBlockEntity) {
            return direction.m_122434_() == source.m_122434_() ? (direction == source ? 1.0f : -1.0f) : (direction.m_122421_() == source.m_122421_() ? -1.0f : 1.0f);
        }
        if (be instanceof SplitShaftBlockEntity) {
            return ((SplitShaftBlockEntity)be).getRotationSpeedModifier(direction);
        }
        return 1.0f;
    }

    private static boolean isLargeToSmallCog(BlockState from, BlockState to, IRotate defTo, BlockPos diff) {
        Direction.Axis axisFrom = (Direction.Axis)from.m_61143_((Property)BlockStateProperties.f_61365_);
        if (axisFrom != defTo.getRotationAxis(to)) {
            return false;
        }
        if (axisFrom.m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_()) != 0) {
            return false;
        }
        for (Direction.Axis axis : Direction.Axis.values()) {
            if (axis == axisFrom || Math.abs(axis.m_7863_(diff.m_123341_(), diff.m_123342_(), diff.m_123343_())) == 1) continue;
            return false;
        }
        return true;
    }

    private static boolean isLargeCogToSpeedController(BlockState from, BlockState to, BlockPos diff) {
        if (!ICogWheel.isLargeCog(from) || !AllBlocks.ROTATION_SPEED_CONTROLLER.has(to)) {
            return false;
        }
        if (!diff.equals((Object)BlockPos.f_121853_.m_7495_())) {
            return false;
        }
        Direction.Axis axis = (Direction.Axis)from.m_61143_((Property)CogWheelBlock.AXIS);
        if (axis.m_122478_()) {
            return false;
        }
        return to.m_61143_(SpeedControllerBlock.HORIZONTAL_AXIS) != axis;
    }

    public static void handleAdded(Level worldIn, BlockPos pos, KineticBlockEntity addedTE) {
        if (worldIn.f_46443_) {
            return;
        }
        if (!worldIn.m_46749_(pos)) {
            return;
        }
        RotationPropagator.propagateNewSource(addedTE);
    }

    private static void propagateNewSource(KineticBlockEntity currentTE) {
        BlockPos pos = currentTE.m_58899_();
        Level world = currentTE.m_58904_();
        for (KineticBlockEntity neighbourTE : RotationPropagator.getConnectedNeighbours(currentTE)) {
            float prevSpeed;
            boolean speedChangedTooOften;
            float speedOfCurrent = currentTE.getTheoreticalSpeed();
            float speedOfNeighbour = neighbourTE.getTheoreticalSpeed();
            float newSpeed = RotationPropagator.getConveyedSpeed(currentTE, neighbourTE);
            float oppositeSpeed = RotationPropagator.getConveyedSpeed(neighbourTE, currentTE);
            if (newSpeed == 0.0f && oppositeSpeed == 0.0f) continue;
            boolean incompatible = Math.signum(newSpeed) != Math.signum(speedOfNeighbour) && newSpeed != 0.0f && speedOfNeighbour != 0.0f;
            boolean tooFast = Math.abs(newSpeed) > (float)((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).intValue() || Math.abs(oppositeSpeed) > (float)((Integer)AllConfigs.server().kinetics.maxRotationSpeed.get()).intValue();
            boolean bl = speedChangedTooOften = currentTE.getFlickerScore() > 128;
            if (tooFast || speedChangedTooOften) {
                world.m_46961_(pos, true);
                return;
            }
            if (incompatible) {
                world.m_46961_(pos, true);
                return;
            }
            if (Math.abs(oppositeSpeed) > Math.abs(speedOfCurrent)) {
                prevSpeed = currentTE.getSpeed();
                currentTE.setSource(neighbourTE.m_58899_());
                currentTE.setSpeed(RotationPropagator.getConveyedSpeed(neighbourTE, currentTE));
                currentTE.onSpeedChanged(prevSpeed);
                currentTE.sendData();
                RotationPropagator.propagateNewSource(currentTE);
                return;
            }
            if (Math.abs(newSpeed) >= Math.abs(speedOfNeighbour)) {
                if (!currentTE.hasNetwork() || currentTE.network.equals(neighbourTE.network)) {
                    float epsilon = Math.abs(speedOfNeighbour) / 256.0f / 256.0f;
                    if (!(Math.abs(newSpeed) > Math.abs(speedOfNeighbour) + epsilon)) continue;
                    world.m_46961_(pos, true);
                    continue;
                }
                if (currentTE.hasSource() && currentTE.source.equals((Object)neighbourTE.m_58899_())) {
                    currentTE.removeSource();
                }
                prevSpeed = neighbourTE.getSpeed();
                neighbourTE.setSource(currentTE.m_58899_());
                neighbourTE.setSpeed(RotationPropagator.getConveyedSpeed(currentTE, neighbourTE));
                neighbourTE.onSpeedChanged(prevSpeed);
                neighbourTE.sendData();
                RotationPropagator.propagateNewSource(neighbourTE);
                continue;
            }
            if (neighbourTE.getTheoreticalSpeed() == newSpeed) continue;
            prevSpeed = neighbourTE.getSpeed();
            neighbourTE.setSpeed(newSpeed);
            neighbourTE.setSource(currentTE.m_58899_());
            neighbourTE.onSpeedChanged(prevSpeed);
            neighbourTE.sendData();
            RotationPropagator.propagateNewSource(neighbourTE);
        }
    }

    public static void handleRemoved(Level worldIn, BlockPos pos, KineticBlockEntity removedBE) {
        if (worldIn.f_46443_) {
            return;
        }
        if (removedBE == null) {
            return;
        }
        if (removedBE.getTheoreticalSpeed() == 0.0f) {
            return;
        }
        for (BlockPos neighbourPos : RotationPropagator.getPotentialNeighbourLocations(removedBE)) {
            KineticBlockEntity neighbourBE;
            BlockEntity blockEntity;
            BlockState neighbourState = worldIn.m_8055_(neighbourPos);
            if (!(neighbourState.m_60734_() instanceof IRotate) || !((blockEntity = worldIn.m_7702_(neighbourPos)) instanceof KineticBlockEntity) || !(neighbourBE = (KineticBlockEntity)blockEntity).hasSource() || !neighbourBE.source.equals((Object)pos)) continue;
            RotationPropagator.propagateMissingSource(neighbourBE);
        }
    }

    private static void propagateMissingSource(KineticBlockEntity updateTE) {
        BlockPos missingSource;
        Level world = updateTE.m_58904_();
        LinkedList<KineticBlockEntity> potentialNewSources = new LinkedList<KineticBlockEntity>();
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        frontier.add(updateTE.m_58899_());
        BlockPos blockPos = missingSource = updateTE.hasSource() ? updateTE.source : null;
        while (!frontier.isEmpty()) {
            BlockPos pos = (BlockPos)frontier.remove(0);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof KineticBlockEntity)) continue;
            KineticBlockEntity currentBE = (KineticBlockEntity)blockEntity;
            currentBE.removeSource();
            currentBE.sendData();
            for (KineticBlockEntity neighbourBE : RotationPropagator.getConnectedNeighbours(currentBE)) {
                if (neighbourBE.m_58899_().equals((Object)missingSource) || !neighbourBE.hasSource()) continue;
                if (!neighbourBE.source.equals((Object)pos)) {
                    potentialNewSources.add(neighbourBE);
                    continue;
                }
                if (neighbourBE.isSource()) {
                    potentialNewSources.add(neighbourBE);
                }
                frontier.add(neighbourBE.m_58899_());
            }
        }
        for (KineticBlockEntity newSource : potentialNewSources) {
            if (!newSource.hasSource() && !newSource.isSource()) continue;
            RotationPropagator.propagateNewSource(newSource);
            return;
        }
    }

    private static KineticBlockEntity findConnectedNeighbour(KineticBlockEntity currentTE, BlockPos neighbourPos) {
        BlockState neighbourState = currentTE.m_58904_().m_8055_(neighbourPos);
        if (!(neighbourState.m_60734_() instanceof IRotate)) {
            return null;
        }
        if (!neighbourState.m_155947_()) {
            return null;
        }
        BlockEntity neighbourBE = currentTE.m_58904_().m_7702_(neighbourPos);
        if (!(neighbourBE instanceof KineticBlockEntity)) {
            return null;
        }
        KineticBlockEntity neighbourKBE = (KineticBlockEntity)neighbourBE;
        if (!(neighbourKBE.m_58900_().m_60734_() instanceof IRotate)) {
            return null;
        }
        if (!RotationPropagator.isConnected(currentTE, neighbourKBE) && !RotationPropagator.isConnected(neighbourKBE, currentTE)) {
            return null;
        }
        return neighbourKBE;
    }

    public static boolean isConnected(KineticBlockEntity from, KineticBlockEntity to) {
        BlockState stateTo;
        BlockState stateFrom = from.m_58900_();
        return RotationPropagator.isLargeCogToSpeedController(stateFrom, stateTo = to.m_58900_(), to.m_58899_().m_121996_((Vec3i)from.m_58899_())) || RotationPropagator.getRotationSpeedModifier(from, to) != 0.0f || from.isCustomConnection(to, stateFrom, stateTo);
    }

    private static List<KineticBlockEntity> getConnectedNeighbours(KineticBlockEntity be) {
        LinkedList<KineticBlockEntity> neighbours = new LinkedList<KineticBlockEntity>();
        for (BlockPos neighbourPos : RotationPropagator.getPotentialNeighbourLocations(be)) {
            KineticBlockEntity neighbourBE = RotationPropagator.findConnectedNeighbour(be, neighbourPos);
            if (neighbourBE == null) continue;
            neighbours.add(neighbourBE);
        }
        return neighbours;
    }

    private static List<BlockPos> getPotentialNeighbourLocations(KineticBlockEntity be) {
        LinkedList<BlockPos> neighbours = new LinkedList<BlockPos>();
        BlockPos blockPos = be.m_58899_();
        Level level = be.m_58904_();
        if (!level.m_46749_(blockPos)) {
            return neighbours;
        }
        for (Direction facing : Iterate.directions) {
            BlockPos relative = blockPos.m_121945_(facing);
            if (!level.m_46749_(relative)) continue;
            neighbours.add(relative);
        }
        BlockState blockState = be.m_58900_();
        if (!(blockState.m_60734_() instanceof IRotate)) {
            return neighbours;
        }
        IRotate block = (IRotate)blockState.m_60734_();
        return be.addPropagationLocations(block, blockState, neighbours);
    }
}

