/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.blockEntity.behaviour.scrollValue;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ScrollValueRenderer {
    public static void tick() {
        boolean highlight;
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        Direction face = result.m_82434_();
        ScrollValueBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, pos, ScrollValueBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            CreateClient.OUTLINER.remove(pos);
            return;
        }
        ItemStack mainhandItem = mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        boolean clipboard = AllBlocks.CLIPBOARD.isIn(mainhandItem);
        if (behaviour.needsWrench && !AllItems.WRENCH.isIn(mainhandItem) && !clipboard) {
            return;
        }
        boolean bl = highlight = behaviour.testHit(target.m_82450_()) && !clipboard;
        if (behaviour instanceof BulkScrollValueBehaviour && AllKeys.ctrlDown()) {
            BulkScrollValueBehaviour bulkScrolling = (BulkScrollValueBehaviour)behaviour;
            for (SmartBlockEntity smartBlockEntity : bulkScrolling.getBulk()) {
                ScrollValueBehaviour other = smartBlockEntity.getBehaviour(ScrollValueBehaviour.TYPE);
                if (other == null) continue;
                ScrollValueRenderer.addBox(world, smartBlockEntity.m_58899_(), face, other, highlight);
            }
        } else {
            ScrollValueRenderer.addBox(world, pos, face, behaviour, highlight);
        }
        if (!highlight) {
            return;
        }
        ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
        tip.add(behaviour.label.m_6881_());
        tip.add(Lang.translateDirect("gui.value_settings.hold_to_edit", new Object[0]));
        CreateClient.VALUE_SETTINGS_HANDLER.showHoverTip(tip);
    }

    protected static void addBox(ClientLevel world, BlockPos pos, Direction face, ScrollValueBehaviour behaviour, boolean highlight) {
        AABB bb = new AABB(Vec3.f_82478_, Vec3.f_82478_).m_82400_(0.5).m_82310_(0.0, 0.0, -0.5).m_82386_(0.0, 0.0, -0.125);
        Component label = behaviour.label;
        ValueBox box = behaviour instanceof ScrollOptionBehaviour ? new ValueBox.IconValueBox(label, ((ScrollOptionBehaviour)behaviour).getIconForSelected(), bb, pos) : new ValueBox.TextValueBox(label, bb, pos, (Component)Components.literal(behaviour.formatValue()));
        box.passive(!highlight).wideOutline();
        CreateClient.OUTLINER.showValueBox(pos, box.transform(behaviour.slotPositioning)).highlightFace(face);
    }
}

