/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.inventories;

import appeng.api.config.FuzzyMode;
import appeng.api.inventories.ContainerAdapter;
import appeng.api.inventories.EmptyInternalInventory;
import appeng.api.inventories.InternalInventoryItemHandler;
import appeng.api.inventories.InternalInventoryIterator;
import appeng.api.inventories.ItemTransfer;
import appeng.api.inventories.PlatformInventoryWrapper;
import appeng.api.inventories.SubInventoryProxy;
import appeng.util.helpers.ItemComparisonHelper;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.ApiStatus;

public interface InternalInventory
extends Iterable<ItemStack>,
ItemTransfer {
    @Nullable
    public static ItemTransfer wrapExternal(@Nullable BlockEntity be, Direction side) {
        if (be == null) {
            return null;
        }
        return be.getCapability(ForgeCapabilities.ITEM_HANDLER, side).map(PlatformInventoryWrapper::new).orElse(null);
    }

    @Nullable
    public static ItemTransfer wrapExternal(Level level, BlockPos pos, Direction side) {
        return InternalInventory.wrapExternal(level.m_7702_(pos), side);
    }

    public static InternalInventory empty() {
        return EmptyInternalInventory.INSTANCE;
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public IItemHandler toItemHandler() {
        return new InternalInventoryItemHandler(this);
    }

    default public Container toContainer() {
        return new ContainerAdapter(this);
    }

    public int size();

    default public int getSlotLimit(int slot) {
        return 64;
    }

    public ItemStack getStackInSlot(int var1);

    public void setItemDirect(int var1, ItemStack var2);

    default public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    default public InternalInventory getSubInventory(int fromSlotInclusive, int toSlotExclusive) {
        return new SubInventoryProxy(this, fromSlotInclusive, toSlotExclusive);
    }

    default public InternalInventory getSlotInv(int slotIndex) {
        Preconditions.checkArgument((slotIndex >= 0 && slotIndex < this.size() ? 1 : 0) != 0, (Object)"slot out of range");
        return new SubInventoryProxy(this, slotIndex, slotIndex + 1);
    }

    default public int getRedstoneSignal() {
        ContainerAdapter adapter = new ContainerAdapter(this);
        return AbstractContainerMenu.m_38938_((Container)adapter);
    }

    @Override
    default public Iterator<ItemStack> iterator() {
        return new InternalInventoryIterator(this);
    }

    @Override
    default public ItemStack addItems(ItemStack stack) {
        return this.addItems(stack, false);
    }

    @Override
    default public ItemStack simulateAdd(ItemStack stack) {
        return this.addItems(stack, true);
    }

    @Override
    default public ItemStack addItems(ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (this.size() <= 54) {
            return this.addItemSlow(stack, simulate);
        }
        return this.addItemFast(stack, simulate);
    }

    private ItemStack addItemSlow(ItemStack stack, boolean simulate) {
        ItemStack remainder = stack.m_41777_();
        for (int pass = 0; pass < 2; ++pass) {
            boolean fillEmptySlots = pass == 1;
            for (int slot = 0; slot < this.size(); ++slot) {
                if (this.getStackInSlot(slot).m_41619_() == fillEmptySlots) {
                    remainder = this.insertItem(slot, remainder, simulate);
                }
                if (!remainder.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
        }
        return remainder;
    }

    private ItemStack addItemFast(ItemStack stack, boolean simulate) {
        ItemStack remainder = stack.m_41777_();
        for (int slot = 0; slot < this.size(); ++slot) {
            if (!(remainder = this.insertItem(slot, remainder, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return remainder;
    }

    @Override
    default public ItemStack removeItems(int amount, ItemStack filter, @Nullable Predicate<ItemStack> destination) {
        int slots = this.size();
        ItemStack rv = ItemStack.f_41583_;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            ItemStack extracted;
            ItemStack is = this.getStackInSlot(slot);
            if (is.m_41619_() || !filter.m_41619_() && !ItemStack.m_150942_((ItemStack)is, (ItemStack)filter) || destination != null && ((extracted = this.extractItem(slot, amount, true)).m_41619_() || !destination.test(extracted)) || (extracted = this.extractItem(slot, amount, false)).m_41619_()) continue;
            if (rv.m_41619_()) {
                rv = extracted;
                filter = extracted;
            } else {
                rv.m_41769_(extracted.m_41613_());
            }
            amount -= extracted.m_41613_();
        }
        return rv;
    }

    @Override
    default public ItemStack simulateRemove(int amount, ItemStack filter, Predicate<ItemStack> destination) {
        int slots = this.size();
        ItemStack rv = ItemStack.f_41583_;
        for (int slot = 0; slot < slots && amount > 0; ++slot) {
            ItemStack extracted;
            ItemStack is = this.getStackInSlot(slot);
            if (is.m_41619_() || !filter.m_41619_() && !ItemStack.m_150942_((ItemStack)is, (ItemStack)filter) || (extracted = this.extractItem(slot, amount, true)).m_41619_() || destination != null && !destination.test(extracted)) continue;
            if (rv.m_41619_()) {
                rv = extracted.m_41777_();
                filter = extracted;
            } else {
                rv.m_41769_(extracted.m_41613_());
            }
            amount -= extracted.m_41613_();
        }
        return rv;
    }

    @Override
    default public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, Predicate<ItemStack> destination) {
        int slots = this.size();
        ItemStack extracted = ItemStack.f_41583_;
        for (int slot = 0; slot < slots && extracted.m_41619_(); ++slot) {
            ItemStack simulated;
            ItemStack is = this.getStackInSlot(slot);
            if (is.m_41619_() || !filter.m_41619_() && !ItemComparisonHelper.isFuzzyEqualItem(is, filter, fuzzyMode) || destination != null && ((simulated = this.extractItem(slot, amount, true)).m_41619_() || !destination.test(simulated))) continue;
            extracted = this.extractItem(slot, amount, false);
        }
        return extracted;
    }

    @Override
    default public ItemStack simulateSimilarRemove(int amount, ItemStack filter, FuzzyMode fuzzyMode, Predicate<ItemStack> destination) {
        int slots = this.size();
        ItemStack extracted = ItemStack.f_41583_;
        for (int slot = 0; slot < slots && extracted.m_41619_(); ++slot) {
            ItemStack is = this.getStackInSlot(slot);
            if (is.m_41619_() || !filter.m_41619_() && !ItemComparisonHelper.isFuzzyEqualItem(is, filter, fuzzyMode) || (extracted = this.extractItem(slot, amount, true)).m_41619_() || destination == null || destination.test(extracted)) continue;
            extracted = ItemStack.f_41583_;
        }
        return extracted;
    }

    default public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        Preconditions.checkArgument((slot >= 0 && slot < this.size() ? 1 : 0) != 0, (Object)"slot out of range");
        if (stack.m_41619_() || !this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack inSlot = this.getStackInSlot(slot);
        int maxSpace = Math.min(this.getSlotLimit(slot), stack.m_41741_());
        int freeSpace = maxSpace - inSlot.m_41613_();
        if (freeSpace <= 0) {
            return stack;
        }
        if (!inSlot.m_41619_() && !ItemStack.m_150942_((ItemStack)inSlot, (ItemStack)stack)) {
            return stack;
        }
        int insertAmount = Math.min(stack.m_41613_(), freeSpace);
        if (!simulate) {
            ItemStack newItem = inSlot.m_41619_() ? stack.m_41777_() : inSlot.m_41777_();
            newItem.m_41764_(inSlot.m_41613_() + insertAmount);
            this.setItemDirect(slot, newItem);
        }
        if (freeSpace >= stack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        ItemStack r = stack.m_41777_();
        r.m_41774_(insertAmount);
        return r;
    }

    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack item = this.getStackInSlot(slot);
        if (item.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (amount >= item.m_41613_()) {
            if (!simulate) {
                this.setItemDirect(slot, ItemStack.f_41583_);
                return item;
            }
            return item.m_41777_();
        }
        ItemStack result = item.m_41777_();
        result.m_41764_(amount);
        if (!simulate) {
            ItemStack reduced = item.m_41777_();
            reduced.m_41774_(amount);
            this.setItemDirect(slot, reduced);
        }
        return result;
    }

    @Override
    default public boolean mayAllowInsertion() {
        return this.size() > 0;
    }

    @ApiStatus.Internal
    default public void sendChangeNotification(int slot) {
    }
}

