/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class IconButton
extends Button
implements ITooltip {
    private boolean halfSize = false;
    private boolean disableClickSound = false;
    private boolean disableBackground = false;

    public IconButton(Button.OnPress onPress) {
        super(0, 0, 16, 16, (Component)Component.m_237119_(), onPress);
    }

    public void setVisibility(boolean vis) {
        this.f_93624_ = vis;
        this.f_93623_ = vis;
    }

    public void m_7435_(SoundManager soundHandler) {
        if (!this.disableClickSound) {
            super.m_7435_(soundHandler);
        }
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        if (this.f_93624_) {
            Icon icon = this.getIcon();
            Blitter blitter = icon.getBlitter();
            if (!this.f_93623_) {
                blitter.opacity(0.5f);
            }
            if (this.halfSize) {
                this.f_93618_ = 8;
                this.f_93619_ = 8;
            }
            RenderSystem.m_69465_();
            RenderSystem.m_69478_();
            if (this.m_93696_()) {
                IconButton.m_93172_((PoseStack)poseStack, (int)(this.f_93620_ - 1), (int)(this.f_93621_ - 1), (int)(this.f_93620_ + this.f_93618_ + 1), (int)(this.f_93621_ + this.f_93619_ + 1), (int)-1);
            }
            if (this.halfSize) {
                poseStack.m_85836_();
                poseStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
                poseStack.m_85841_(0.5f, 0.5f, 1.0f);
                if (!this.disableBackground) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(0, 0).blit(poseStack, this.m_93252_());
                }
                blitter.dest(0, 0).blit(poseStack, this.m_93252_());
                poseStack.m_85849_();
            } else {
                if (!this.disableBackground) {
                    Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(this.f_93620_, this.f_93621_).blit(poseStack, this.m_93252_());
                }
                icon.getBlitter().dest(this.f_93620_, this.f_93621_).blit(poseStack, this.m_93252_());
            }
            RenderSystem.m_69482_();
            Item item = this.getItemOverlay();
            if (item != null) {
                Minecraft.m_91087_().m_91291_().m_115123_(new ItemStack((ItemLike)item), this.f_93620_, this.f_93621_);
            }
        }
    }

    protected abstract Icon getIcon();

    @Nullable
    protected Item getItemOverlay() {
        return null;
    }

    @Override
    public List<Component> getTooltipMessage() {
        return Collections.singletonList(this.m_6035_());
    }

    @Override
    public Rect2i getTooltipArea() {
        return new Rect2i(this.f_93620_, this.f_93621_, this.halfSize ? 8 : 16, this.halfSize ? 8 : 16);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.f_93624_;
    }

    public boolean isHalfSize() {
        return this.halfSize;
    }

    public void setHalfSize(boolean halfSize) {
        this.halfSize = halfSize;
    }

    public boolean isDisableClickSound() {
        return this.disableClickSound;
    }

    public void setDisableClickSound(boolean disableClickSound) {
        this.disableClickSound = disableClickSound;
    }

    public boolean isDisableBackground() {
        return this.disableBackground;
    }

    public void setDisableBackground(boolean disableBackground) {
        this.disableBackground = disableBackground;
    }
}

