/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.FlowTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.flow.LytFlowLink;
import appeng.client.guidebook.document.flow.LytFlowParent;
import appeng.client.guidebook.document.flow.LytTooltipSpan;
import appeng.client.guidebook.document.interaction.ItemTooltip;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.libs.mdast.model.MdAstNode;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class ItemLinkCompiler
extends FlowTagCompiler {
    @Override
    public void compile(PageCompiler compiler, LytFlowParent parent, MdxJsxElementFields el) {
        Pair<ResourceLocation, Item> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
        if (itemAndId == null) {
            return;
        }
        ResourceLocation id = (ResourceLocation)itemAndId.getLeft();
        Item item = (Item)itemAndId.getRight();
        PageAnchor linksTo = (PageAnchor)compiler.getIndex(ItemIndex.class).get(id);
        if (linksTo == null && id.m_135827_().equals(compiler.getId().m_135827_())) {
            parent.append(compiler.createErrorFlowContent("No page found for item " + id, (MdAstNode)((Object)el)));
            return;
        }
        ItemStack stack = item.m_7968_();
        if (linksTo == null || linksTo.anchor() == null && compiler.getId().equals((Object)linksTo.pageId())) {
            LytTooltipSpan span = new LytTooltipSpan();
            span.modifyStyle(style -> style.italic(true));
            compiler.compileComponentToFlow((FormattedText)stack.m_41786_(), span);
            span.setTooltip(new ItemTooltip(stack));
            parent.append(span);
        } else {
            LytFlowLink link = new LytFlowLink();
            link.setClickCallback(screen -> screen.navigateTo(linksTo));
            compiler.compileComponentToFlow((FormattedText)stack.m_41786_(), link);
            link.setTooltip(new ItemTooltip(stack));
            parent.append(link);
        }
    }
}

