/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.core.AELog;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.ProcessingPatternEncoding;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ProcessingPatternItem
extends EncodedPatternItem {
    public ProcessingPatternItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public AEProcessingPattern decode(ItemStack stack, Level level, boolean tryRecovery) {
        return this.decode(AEItemKey.of(stack), level);
    }

    @Override
    public AEProcessingPattern decode(AEItemKey what, Level level) {
        if (what == null || !what.hasTag()) {
            return null;
        }
        try {
            return new AEProcessingPattern(what);
        }
        catch (Exception e) {
            AELog.warn("Could not decode an invalid processing pattern %s: %s", what.getTag(), e);
            return null;
        }
    }

    public ItemStack encode(GenericStack[] sparseInputs, GenericStack[] sparseOutputs) {
        if (Arrays.stream(sparseInputs).noneMatch(Objects::nonNull)) {
            throw new IllegalArgumentException("At least one input must be non-null.");
        }
        Objects.requireNonNull(sparseOutputs[0], "The first (primary) output must be non-null.");
        ItemStack stack = new ItemStack((ItemLike)this);
        ProcessingPatternEncoding.encodeProcessingPattern(stack.m_41784_(), sparseInputs, sparseOutputs);
        return stack;
    }
}

