/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.util.WorldCoord;
import appeng.block.spatial.MatrixFrameBlock;
import appeng.core.definitions.AEBlocks;
import appeng.core.stats.AdvancementTriggers;
import appeng.spatial.CachedPlane;
import appeng.spatial.ISpatialVisitor;
import appeng.spatial.SpatialStorageDimensionIds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.ITeleporter;

public class SpatialStorageHelper {
    private static SpatialStorageHelper instance;

    public static SpatialStorageHelper getInstance() {
        if (instance == null) {
            instance = new SpatialStorageHelper();
        }
        return instance;
    }

    private Entity teleportEntity(Entity entity, TelDestination link) {
        PortalInfo portalInfo;
        ServerLevel newLevel;
        ServerLevel oldLevel;
        try {
            oldLevel = (ServerLevel)entity.f_19853_;
            newLevel = link.dim;
        }
        catch (Throwable e) {
            return entity;
        }
        if (oldLevel == null) {
            return entity;
        }
        if (newLevel == null) {
            return entity;
        }
        if (newLevel == oldLevel) {
            newLevel.m_7726_().m_7587_(Mth.m_14107_((double)link.x) >> 4, Mth.m_14107_((double)link.z) >> 4, ChunkStatus.f_62326_, true);
            entity.m_6021_(link.x, link.y, link.z);
            return entity;
        }
        if (entity.m_20159_()) {
            return this.teleportEntity(entity.m_20202_(), link);
        }
        List passengers = entity.m_20197_();
        ArrayList<Entity> passengersOnOtherSide = new ArrayList<Entity>(passengers.size());
        for (Entity passenger : passengers) {
            passenger.m_8127_();
            passengersOnOtherSide.add(this.teleportEntity(passenger, link));
        }
        newLevel.m_7726_().m_7587_(Mth.m_14107_((double)link.x) >> 4, Mth.m_14107_((double)link.z) >> 4, ChunkStatus.f_62326_, true);
        if (entity instanceof ServerPlayer && link.dim.m_46472_() == SpatialStorageDimensionIds.WORLD_ID) {
            AdvancementTriggers.SPATIAL_EXPLORER.trigger((ServerPlayer)entity);
        }
        if ((entity = entity.changeDimension(link.dim, new ITeleporter(){
            final /* synthetic */ PortalInfo val$portalInfo;
            {
                this.val$portalInfo = portalInfo;
            }

            public Entity placeEntity(Entity entity, ServerLevel currentLevel, ServerLevel destLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
                return repositionEntity.apply(false);
            }

            public PortalInfo getPortalInfo(Entity entity, ServerLevel destLevel, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                return this.val$portalInfo;
            }
        })) != null && !passengersOnOtherSide.isEmpty()) {
            for (Entity passanger : passengersOnOtherSide) {
                passanger.m_7998_(entity, true);
            }
        }
        return entity;
    }

    private void transverseEdges(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, ISpatialVisitor visitor) {
        int x;
        int z;
        for (int y = minY; y < maxY; ++y) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(new BlockPos(minX, y, z));
                visitor.visit(new BlockPos(maxX, y, z));
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(new BlockPos(x, minY, z));
                visitor.visit(new BlockPos(x, maxY, z));
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                visitor.visit(new BlockPos(x, y, minZ));
                visitor.visit(new BlockPos(x, y, maxZ));
            }
        }
    }

    public void swapRegions(ServerLevel srcLevel, int srcX, int srcY, int srcZ, ServerLevel dstLevel, int dstX, int dstY, int dstZ, int scaleX, int scaleY, int scaleZ) {
        MatrixFrameBlock matrixFrameBlock = AEBlocks.MATRIX_FRAME.block();
        this.transverseEdges(dstX - 1, dstY - 1, dstZ - 1, dstX + scaleX + 1, dstY + scaleY + 1, dstZ + scaleZ + 1, new WrapInMatrixFrame(matrixFrameBlock.m_49966_(), (Level)dstLevel));
        AABB srcBox = new AABB((double)srcX, (double)srcY, (double)srcZ, (double)(srcX + scaleX + 1), (double)(srcY + scaleY + 1), (double)(srcZ + scaleZ + 1));
        AABB dstBox = new AABB((double)dstX, (double)dstY, (double)dstZ, (double)(dstX + scaleX + 1), (double)(dstY + scaleY + 1), (double)(dstZ + scaleZ + 1));
        CachedPlane cDst = new CachedPlane(dstLevel, dstX, dstY, dstZ, dstX + scaleX, dstY + scaleY, dstZ + scaleZ);
        CachedPlane cSrc = new CachedPlane(srcLevel, srcX, srcY, srcZ, srcX + scaleX, srcY + scaleY, srcZ + scaleZ);
        cSrc.swap(cDst);
        List srcE = srcLevel.m_45976_(Entity.class, srcBox);
        List dstE = dstLevel.m_45976_(Entity.class, dstBox);
        for (Entity e : dstE) {
            this.teleportEntity(e, new TelDestination(srcLevel, srcBox, e.m_20185_(), e.m_20186_(), e.m_20189_(), -dstX + srcX, -dstY + srcY, -dstZ + srcZ));
        }
        for (Entity e : srcE) {
            this.teleportEntity(e, new TelDestination(dstLevel, dstBox, e.m_20185_(), e.m_20186_(), e.m_20189_(), -srcX + dstX, -srcY + dstY, -srcZ + dstZ));
        }
        for (WorldCoord wc : cDst.getUpdates()) {
            cSrc.getLevel().m_46672_(wc.getPos(), Blocks.f_50016_);
        }
        for (WorldCoord wc : cSrc.getUpdates()) {
            cSrc.getLevel().m_46672_(wc.getPos(), Blocks.f_50016_);
        }
        this.transverseEdges(srcX - 1, srcY - 1, srcZ - 1, srcX + scaleX + 1, srcY + scaleY + 1, srcZ + scaleZ + 1, new TriggerUpdates((Level)srcLevel));
        this.transverseEdges(dstX - 1, dstY - 1, dstZ - 1, dstX + scaleX + 1, dstY + scaleY + 1, dstZ + scaleZ + 1, new TriggerUpdates((Level)dstLevel));
        this.transverseEdges(srcX, srcY, srcZ, srcX + scaleX, srcY + scaleY, srcZ + scaleZ, new TriggerUpdates((Level)srcLevel));
        this.transverseEdges(dstX, dstY, dstZ, dstX + scaleX, dstY + scaleY, dstZ + scaleZ, new TriggerUpdates((Level)dstLevel));
    }

    private static class TelDestination {
        private final ServerLevel dim;
        private final double x;
        private final double y;
        private final double z;

        TelDestination(ServerLevel dimension, AABB srcBox, double x, double y, double z, int blockEntityX, int blockEntityY, int blockEntityZ) {
            this.dim = dimension;
            this.x = Math.min(srcBox.f_82291_ - 0.5, Math.max(srcBox.f_82288_ + 0.5, x + (double)blockEntityX));
            this.y = Math.min(srcBox.f_82292_ - 0.5, Math.max(srcBox.f_82289_ + 0.5, y + (double)blockEntityY));
            this.z = Math.min(srcBox.f_82293_ - 0.5, Math.max(srcBox.f_82290_ + 0.5, z + (double)blockEntityZ));
        }
    }

    private static class WrapInMatrixFrame
    implements ISpatialVisitor {
        private final Level dst;
        private final BlockState state;

        public WrapInMatrixFrame(BlockState state, Level dst2) {
            this.dst = dst2;
            this.state = state;
        }

        @Override
        public void visit(BlockPos pos) {
            this.dst.m_46597_(pos, this.state);
        }
    }

    private static class TriggerUpdates
    implements ISpatialVisitor {
        private final Level dst;

        public TriggerUpdates(Level dst2) {
            this.dst = dst2;
        }

        @Override
        public void visit(BlockPos pos) {
            BlockState state = this.dst.m_8055_(pos);
            Block blk = state.m_60734_();
            blk.m_6861_(state, this.dst, pos, blk, pos, false);
        }
    }
}

