/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.content.core;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public abstract class FluidAndEnergyScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    private final int fluidXOffset;
    private final int progressXOffset;
    private final ResourceLocation texture;

    public FluidAndEnergyScreen(T arg, Inventory arg2, Component arg3, int fluidXOffset, int progressXOffset, ResourceLocation texture) {
        super(arg, arg2, arg3);
        this.fluidXOffset = fluidXOffset;
        this.progressXOffset = progressXOffset;
        this.texture = texture;
    }

    public void m_6305_(PoseStack arg, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(arg, mouseX, mouseY, partialTicks);
        if (mouseX > this.f_97735_ + this.fluidXOffset && mouseX < this.f_97735_ + this.fluidXOffset + 19 && mouseY > this.f_97736_ + 3 && mouseY < this.f_97736_ + 5 + 65) {
            arg.m_85836_();
            arg.m_85837_((double)(mouseX - 5), (double)mouseY, 600.0);
            arg.m_85841_(0.6f, 0.6f, 0.0f);
            this.m_96602_(arg, (Component)Component.m_237113_((String)(this.getFluidStack().getAmount() + " / " + this.getFluidCapacity() + " mB")), 0, 0);
            arg.m_85849_();
        }
        if (mouseX > this.f_97735_ + 166 && mouseX < this.f_97735_ + 174 && mouseY > this.f_97736_ + 3 && mouseY < this.f_97736_ + 5 + 65) {
            MutableComponent energyText = Component.m_237113_((String)(this.getEnergyAmount() + " / " + this.getEnergyCapacity() + " FE"));
            int width = this.f_96547_.m_92852_((FormattedText)energyText);
            int scaledWidth = (int)((float)width * 0.6f);
            arg.m_85836_();
            arg.m_85837_((double)(mouseX - 10 - scaledWidth), (double)mouseY, 600.0);
            arg.m_85841_(0.6f, 0.6f, 0.0f);
            this.m_96602_(arg, (Component)energyText, 0, 0);
            arg.m_85849_();
        }
        this.m_7025_(arg, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack arg, float f, int i, int j) {
        this.m_7333_(arg);
        arg.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        this.m_93228_(arg, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        arg.m_85849_();
        arg.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        float x = (float)this.getEnergyAmount() / (float)this.getEnergyCapacity();
        int energyHeight = (int)(x * 65.0f);
        this.m_93228_(arg, this.f_97735_ + this.f_97726_ - 9, this.f_97736_ + 4 + 65 - energyHeight, 197, 69 - energyHeight, 5, energyHeight);
        arg.m_85849_();
        RenderSystem.m_69461_();
        FluidStack fluidStack = this.getFluidStack();
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation texture = fluidExtensions.getStillTexture(fluidStack);
        TextureAtlasSprite atlasSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(texture);
        float fluidHeight = (float)this.getFluidStack().getAmount() / (float)this.getFluidCapacity() * 65.0f;
        int textureHeight = 16;
        int tilesRequired = (int)Math.ceil(fluidHeight / (float)textureHeight);
        arg.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        int[] cols = FluidAndEnergyScreen.decomposeColor(fluidExtensions.getTintColor(fluidStack));
        for (int k = 0; k < tilesRequired; ++k) {
            int height = 16 - (int)Math.min((float)textureHeight, fluidHeight - (float)(k * textureHeight));
            FluidAndEnergyScreen.drawFluidTexture(arg, this.f_97735_ + (this.fluidXOffset + 1), this.f_97736_ + 6 + 47 - k * textureHeight, atlasSprite, height, cols);
        }
        RenderSystem.m_69461_();
        arg.m_85849_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        arg.m_85836_();
        arg.m_85837_(0.0, 0.0, 101.0);
        this.m_93228_(arg, this.f_97735_ + (this.fluidXOffset + 1), this.f_97736_ + 6, 178, 3, 18, 67);
        arg.m_85849_();
        if (this.getProgressRequired() > 0) {
            float computedPercentage = (float)this.getProgress() / (float)this.getProgressRequired() * 24.0f;
            this.m_93228_(arg, this.f_97735_ + this.progressXOffset, this.f_97736_ + 28, 203, 0, (int)computedPercentage + 1, 16);
        }
    }

    private static void drawFluidTexture(PoseStack stack, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int[] cols) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= 0.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        Matrix4f posMat = stack.m_85850_().m_85861_();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder worldrenderer = tessellator.m_85915_();
        worldrenderer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        worldrenderer.m_85982_(posMat, xCoord, yCoord + 16.0f, 100.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMin, vMax).m_5752_();
        worldrenderer.m_85982_(posMat, xCoord + 16.0f - 0.0f, yCoord + 16.0f, 100.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMax, vMax).m_5752_();
        worldrenderer.m_85982_(posMat, xCoord + 16.0f - 0.0f, yCoord + (float)maskTop, 100.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMax, vMin).m_5752_();
        worldrenderer.m_85982_(posMat, xCoord, yCoord + (float)maskTop, 100.0f).m_6122_(cols[1], cols[2], cols[3], cols[0]).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public static int[] decomposeColor(int color) {
        int[] res = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return res;
    }

    public abstract int getEnergyAmount();

    public abstract int getEnergyCapacity();

    public abstract int getFluidCapacity();

    public abstract FluidStack getFluidStack();

    public abstract int getProgress();

    public abstract int getProgressRequired();
}

