/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsba.tools.content.core;

import dev.ftb.ftbsba.tools.recipies.FusingMachineRecipe;
import dev.ftb.ftbsba.tools.recipies.SuperCoolerRecipe;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class RecipeCaches {
    public static final RecipeCache<FusingMachineRecipe> FUSING_MACHINE = new RecipeCache((itemHandler, fluidHandler) -> RecipeCaches.hashItemHandler(itemHandler));
    public static final RecipeCache<SuperCoolerRecipe> SUPER_COOLER = new RecipeCache(RecipeCaches::makeSuperCoolerHash);

    private static int makeSuperCoolerHash(IItemHandler itemHandler, IFluidHandler fluidHandler) {
        return Objects.hash(RecipeCaches.hashItemHandler(itemHandler), RecipeCaches.hashFluidHandler(fluidHandler));
    }

    private static int hashItemHandler(IItemHandler handler) {
        IntArrayList ids = new IntArrayList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ids.add(Registry.f_122827_.m_7447_((Object)handler.getStackInSlot(i).m_41720_()));
        }
        return Arrays.hashCode(ids.intStream().sorted().toArray());
    }

    private static int hashFluidHandler(IFluidHandler handler) {
        IntArrayList ids = new IntArrayList();
        for (int i = 0; i < handler.getTanks(); ++i) {
            ids.add(Registry.f_122822_.m_7447_((Object)handler.getFluidInTank(i).getFluid()));
        }
        return Arrays.hashCode(ids.intStream().sorted().toArray());
    }

    public static void clearAll() {
        FUSING_MACHINE.clear();
        SUPER_COOLER.clear();
    }

    public static class RecipeCache<R extends Recipe<?>> {
        private static final int MAX_CACHE_SIZE = 1024;
        private final KeyGen keyGen;
        private final Int2ObjectLinkedOpenHashMap<Optional<R>> recipeCache = new Int2ObjectLinkedOpenHashMap(1024, 0.25f);

        public RecipeCache(KeyGen keyGen) {
            this.keyGen = keyGen;
        }

        public Optional<R> getCachedRecipe(Supplier<Optional<R>> recipeFinder, IItemHandler itemHandler, IFluidHandler fluidHandler) {
            int key = this.keyGen.genHashKey(itemHandler, fluidHandler);
            if (this.recipeCache.containsKey(key)) {
                return (Optional)this.recipeCache.getAndMoveToFirst(key);
            }
            Optional<R> newRecipe = recipeFinder.get();
            while (this.recipeCache.size() >= 1024) {
                this.recipeCache.removeLast();
            }
            this.recipeCache.put(key, newRecipe);
            return newRecipe;
        }

        private void clear() {
            this.recipeCache.clear();
        }

        @FunctionalInterface
        public static interface KeyGen {
            public int genHashKey(IItemHandler var1, IFluidHandler var2);
        }
    }

    public static class ReloadListener
    implements PreparableReloadListener {
        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return CompletableFuture.runAsync(RecipeCaches::clearAll, gameExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0));
        }
    }
}

