/*
 * Decompiled with CFR 0.152.
 */
package wolforce.simpleshops.utils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import wolforce.simpleshops.utils.CustomVertexConsumer;
import wolforce.simpleshops.utils.Util;

public class UtilRenderItem {
    public static Minecraft MC = Minecraft.m_91087_();
    public static ItemRenderer renderItem = MC.m_91291_();
    public static TextureManager textureManager = UtilRenderItem.MC.f_90987_;
    public static LocalPlayer player = Minecraft.m_91087_().f_91074_;
    private ItemStack stack;
    private PoseStack poseStack;
    private Vec3 position = null;
    private Vec3 scale = null;
    private CustomVertexConsumer.ColorAction colorAction = null;
    private MultiBufferSource buffer = null;
    private Integer combinedLight = null;
    private Integer combinedOverlay = null;
    private boolean rotate = false;
    private Screen screen;
    private Vec2 mousePos;
    private static final Vec3 DEFAULT_POSITION = new Vec3(0.0, 0.0, 0.0);
    private static final Vec3 DEFAULT_SCALE = new Vec3(1.0, 1.0, 1.0);
    private static final int DEFAULT_COMBINED_LIGHT = 0xF000F0;
    private static final int DEFAULT_COMBINED_OVERLAY = OverlayTexture.f_118083_;

    private static MultiBufferSource DEFAULT_BUFFER() {
        return MC.m_91269_().m_110104_();
    }

    public static UtilRenderItem init(ItemStack stack) {
        return new UtilRenderItem(stack);
    }

    private UtilRenderItem(ItemStack stack) {
        this.stack = stack;
    }

    public UtilRenderItem pose(PoseStack poseStack) {
        this.poseStack = poseStack;
        return this;
    }

    public UtilRenderItem pos(Vec3 position) {
        this.position = position;
        return this;
    }

    public UtilRenderItem scale(double x, double y, double z) {
        this.scale = new Vec3(x, y, z);
        return this;
    }

    public UtilRenderItem pos(double x, double y, double z) {
        this.position = new Vec3(x, y, z);
        return this;
    }

    public UtilRenderItem scale(Vec3 scale) {
        this.scale = new Vec3(scale.f_82479_, scale.f_82480_, scale.f_82481_);
        return this;
    }

    public UtilRenderItem color(CustomVertexConsumer.ColorAction colorAction) {
        this.colorAction = colorAction;
        return this;
    }

    public UtilRenderItem rotate() {
        this.rotate = true;
        return this;
    }

    public UtilRenderItem buffer(MultiBufferSource buffer) {
        this.buffer = buffer;
        return this;
    }

    public UtilRenderItem combined(int combinedLight, int combinedOverlay) {
        this.combinedLight = combinedLight;
        this.combinedOverlay = combinedOverlay;
        return this;
    }

    public UtilRenderItem screen(Screen screen) {
        this.screen = screen;
        return this;
    }

    public UtilRenderItem mouse(Vec2 mousePos) {
        this.mousePos = mousePos;
        return this;
    }

    public void renderGui() {
        if (!Util.isValid(this.stack)) {
            return;
        }
        PoseStack poseStack = this.poseStack != null ? this.poseStack : RenderSystem.m_157191_();
        MultiBufferSource buffer = this.buffer != null ? this.buffer : MC.m_91269_().m_110104_();
        Vec3 position = this.position != null ? this.position : DEFAULT_POSITION;
        Vec3 scale = this.scale != null ? this.scale : DEFAULT_SCALE;
        int combinedLight = this.combinedLight != null ? this.combinedLight : 0xF000F0;
        int combinedOverlay = this.combinedOverlay != null ? this.combinedOverlay : DEFAULT_COMBINED_OVERLAY;
        BakedModel model = renderItem.m_174264_(this.stack, null, (LivingEntity)player, 0);
        poseStack.m_85836_();
        if (scale != null) {
            poseStack.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
        }
        if (position != null) {
            poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        }
        if (this.rotate) {
            long time = System.currentTimeMillis() / 40L % 360L;
            poseStack.m_85845_(new Quaternion(Vector3f.f_122225_, (float)time, true));
        }
        poseStack.m_85837_(8.0, 8.0, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        Lighting.m_84930_();
        if (this.colorAction != null) {
            this.renderCustomVertexConsumer(this.stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), buffer, combinedLight, combinedOverlay, model, this.colorAction);
        } else {
            renderItem.m_115143_(this.stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), buffer, combinedLight, combinedOverlay, model);
        }
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.m_109911_();
        }
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        if (this.screen != null && this.mousePos != null && (double)this.mousePos.f_82470_ > position.f_82479_ && (double)this.mousePos.f_82471_ > position.f_82480_ && (double)this.mousePos.f_82470_ < position.f_82479_ + 16.0 && (double)this.mousePos.f_82471_ < position.f_82480_ + 16.0) {
            this.screen.renderComponentTooltip(poseStack, this.screen.m_96555_(this.stack), (int)this.mousePos.f_82470_, (int)this.mousePos.f_82471_, this.stack);
        }
        poseStack.m_85849_();
    }

    public void render() {
        if (!Util.isValid(this.stack)) {
            return;
        }
        MultiBufferSource buffer = this.buffer != null ? this.buffer : UtilRenderItem.DEFAULT_BUFFER();
        Vec3 position = this.position != null ? this.position : DEFAULT_POSITION;
        Vec3 scale = this.scale != null ? this.scale : DEFAULT_SCALE;
        int combinedLight = this.combinedLight != null ? this.combinedLight : 0xF000F0;
        int combinedOverlay = this.combinedOverlay != null ? this.combinedOverlay : DEFAULT_COMBINED_OVERLAY;
        BakedModel model = renderItem.m_174264_(this.stack, null, (LivingEntity)player, 0);
        this.poseStack.m_85836_();
        boolean render3D = model.m_7539_();
        if (render3D) {
            Lighting.m_84931_();
        } else {
            Lighting.m_84930_();
        }
        if (scale != null) {
            this.poseStack.m_85841_((float)scale.f_82479_, (float)scale.f_82480_, (float)scale.f_82481_);
        }
        if (position != null) {
            this.poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        }
        if (this.rotate) {
            long time = System.currentTimeMillis() / 40L % 360L;
            this.poseStack.m_85845_(new Quaternion(Vector3f.f_122225_, (float)time, true));
        }
        if (!render3D) {
            this.poseStack.m_85841_(0.8f, 0.8f, 0.8f);
            this.poseStack.m_85837_(0.0, 0.1, 0.0);
        }
        if (this.colorAction != null) {
            this.renderCustomVertexConsumer(this.stack, ItemTransforms.TransformType.GROUND, false, this.poseStack, buffer, combinedLight, combinedOverlay, model, this.colorAction);
        } else {
            renderItem.m_115143_(this.stack, ItemTransforms.TransformType.GROUND, false, this.poseStack, buffer, combinedLight, combinedOverlay, model);
        }
        this.poseStack.m_85849_();
    }

    public void renderCustomVertexConsumer(ItemStack stack, ItemTransforms.TransformType transformType, boolean p_115146_, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel bakedModel, CustomVertexConsumer.ColorAction colorAction) {
        ItemRenderer itemRenderer = MC.m_91291_();
        if (!stack.m_41619_()) {
            boolean flag;
            poseStack.m_85836_();
            boolean bl = flag = transformType == ItemTransforms.TransformType.GUI || transformType == ItemTransforms.TransformType.GROUND || transformType == ItemTransforms.TransformType.FIXED;
            if (!flag || stack.m_150930_(Items.f_42713_) || stack.m_150930_(Items.f_151059_)) {
                // empty if block
            }
            bakedModel = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)bakedModel, (ItemTransforms.TransformType)transformType, (boolean)p_115146_);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            if (!(bakedModel.m_7521_() || stack.m_150930_(Items.f_42713_) && !flag)) {
                Block block;
                boolean flag1 = transformType != ItemTransforms.TransformType.GUI && !transformType.m_111841_() && stack.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)stack.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                for (BakedModel model : bakedModel.getRenderPasses(stack, flag1)) {
                    for (RenderType rendertype : model.getRenderTypes(stack, flag1)) {
                        VertexConsumer vertexconsumer;
                        if (stack.m_204117_(ItemTags.f_215866_) && stack.m_41790_()) {
                            poseStack.m_85836_();
                            PoseStack.Pose posestack$pose = poseStack.m_85850_();
                            if (transformType == ItemTransforms.TransformType.GUI) {
                                posestack$pose.m_85861_().m_27630_(0.5f);
                            } else if (transformType.m_111841_()) {
                                posestack$pose.m_85861_().m_27630_(0.75f);
                            }
                            vertexconsumer = flag1 ? ItemRenderer.m_115207_((MultiBufferSource)buffer, (RenderType)rendertype, (PoseStack.Pose)posestack$pose) : ItemRenderer.m_115180_((MultiBufferSource)buffer, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                            poseStack.m_85849_();
                        } else {
                            vertexconsumer = flag1 ? ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.m_41790_());
                        }
                        itemRenderer.m_115189_(model, stack, combinedLight, combinedOverlay, poseStack, (VertexConsumer)new CustomVertexConsumer(vertexconsumer, colorAction));
                    }
                }
            } else {
                IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, transformType, poseStack, buffer, combinedLight, combinedOverlay);
            }
            poseStack.m_85849_();
        }
    }
}

