/*
 * Decompiled with CFR 0.152.
 */
package uppers.tiles;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import uppers.blocks.UpperBlock;
import uppers.tiles.IUpper;
import uppers.tiles.UpperBlockEntity;

public class InventoryCodeHooksTweaked {
    @Nullable
    public static Boolean extractHook(Level level, IUpper dest) {
        return InventoryCodeHooksTweaked.getItemHandler(level, dest, Direction.DOWN).map(itemHandlerResult -> {
            IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extractItem = handler.extractItem(i, 1, true);
                if (extractItem.m_41619_()) continue;
                for (int j = 0; j < dest.m_6643_(); ++j) {
                    ItemStack destStack = dest.m_8020_(j);
                    if (!dest.m_7013_(j, extractItem) || !destStack.m_41619_() && (destStack.m_41613_() >= destStack.m_41741_() || destStack.m_41613_() >= dest.m_6893_() || !ItemHandlerHelper.canItemStacksStack((ItemStack)extractItem, (ItemStack)destStack))) continue;
                    extractItem = handler.extractItem(i, 1, false);
                    if (destStack.m_41619_()) {
                        dest.m_6836_(j, extractItem);
                    } else {
                        destStack.m_41769_(1);
                        dest.m_6836_(j, destStack);
                    }
                    dest.m_6596_();
                    return true;
                }
            }
            return false;
        }).orElse(null);
    }

    public static boolean insertHook(UpperBlockEntity tileEntityUpper) {
        Direction upperFacing = (Direction)tileEntityUpper.m_58900_().m_61143_((Property)UpperBlock.FACING);
        return InventoryCodeHooksTweaked.getItemHandler(tileEntityUpper.m_58904_(), tileEntityUpper, upperFacing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (InventoryCodeHooksTweaked.isFull(itemHandler)) {
                return false;
            }
            for (int i = 0; i < tileEntityUpper.m_6643_(); ++i) {
                if (tileEntityUpper.m_8020_(i).m_41619_()) continue;
                ItemStack originalSlotContents = tileEntityUpper.m_8020_(i).m_41777_();
                ItemStack insertStack = tileEntityUpper.m_7407_(i, 1);
                ItemStack remainder = InventoryCodeHooksTweaked.putStackInInventoryAllSlots((BlockEntity)tileEntityUpper, destination, itemHandler, insertStack);
                if (remainder.m_41619_()) {
                    return true;
                }
                tileEntityUpper.m_6836_(i, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    private static ItemStack putStackInInventoryAllSlots(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.m_41619_(); ++slot) {
            stack = InventoryCodeHooksTweaked.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(BlockEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).m_41619_()) {
            UpperBlockEntity destinationUpper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = InventoryCodeHooksTweaked.isEmpty(destInventory);
            if (itemstack.m_41619_()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.f_41583_;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemstack, (ItemStack)stack)) {
                int originalSize = stack.m_41613_();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).m_41613_();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof UpperBlockEntity && !(destinationUpper = (UpperBlockEntity)destination).isOnCustomCooldown()) {
                int k = 0;
                if (source instanceof UpperBlockEntity && destinationUpper.getLastUpdateTime() >= ((UpperBlockEntity)source).getLastUpdateTime()) {
                    k = 1;
                }
                destinationUpper.setCooldown(8 - k);
            }
        }
        return stack;
    }

    private static Optional<Pair<IItemHandler, Object>> getItemHandler(Level level, IUpper upper, Direction upperFacing) {
        double x = upper.m_6343_() + (double)upperFacing.m_122429_();
        double y = upper.m_6358_() + (double)upperFacing.m_122430_();
        double z = upper.m_6446_() + (double)upperFacing.m_122431_();
        return InventoryCodeHooksTweaked.getItemHandler(level, x, y, z, upperFacing.m_122424_());
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.m_41619_() && stackInSlot.m_41613_() == stackInSlot.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.m_41613_() <= 0) continue;
            return false;
        }
        return true;
    }

    public static Optional<Pair<IItemHandler, Object>> getItemHandler(Level level, double x, double y, double z, Direction side) {
        BlockEntity tileentity;
        int k;
        int j;
        int i = Mth.m_14107_((double)x);
        BlockPos blockpos = new BlockPos(i, j = Mth.m_14107_((double)y), k = Mth.m_14107_((double)z));
        BlockState state = level.m_8055_(blockpos);
        if (state.m_155947_() && (tileentity = level.m_7702_(blockpos)) != null) {
            return tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(capability -> ImmutablePair.of((Object)capability, (Object)tileentity));
        }
        return Optional.empty();
    }
}

