/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.data;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import shadows.hostilenetworks.Hostile;
import shadows.hostilenetworks.data.ModelTier;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.placebo.json.ItemAdapter;
import shadows.placebo.json.NBTAdapter;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.TypeKeyed;

public class DataModel
extends TypeKeyed.TypeKeyedBase<DataModel> {
    public static final PSerializer<DataModel> SERIALIZER = PSerializer.builder((String)"Data Model", DataModel::read).toJson(DataModel::write).networked(DataModel::read, DataModel::write).build();
    protected final EntityType<? extends LivingEntity> type;
    protected final List<EntityType<? extends LivingEntity>> subtypes;
    protected final MutableComponent name;
    protected final CompoundTag displayNbt;
    protected final float guiScale;
    protected final float guiXOff;
    protected final float guiYOff;
    protected final float guiZOff;
    protected final int simCost;
    protected final ItemStack input;
    protected final ItemStack baseDrop;
    protected final String triviaKey;
    protected final List<ItemStack> fabDrops;
    protected final int[] tierData;
    protected final int[] dataPerKill;

    public DataModel(EntityType<? extends LivingEntity> type, List<EntityType<? extends LivingEntity>> subtypes, MutableComponent name, CompoundTag displayNbt, float guiScale, float guiXOff, float guiYOff, float guiZOff, int simCost, ItemStack input, ItemStack baseDrop, String triviaKey, List<ItemStack> fabDrops, int[] tierData, int[] dataPerKill) {
        this.type = type;
        this.subtypes = subtypes;
        this.name = name;
        this.displayNbt = displayNbt;
        this.guiScale = guiScale;
        this.guiYOff = guiYOff;
        this.guiXOff = guiXOff;
        this.guiZOff = guiZOff;
        this.simCost = simCost;
        this.input = input;
        this.baseDrop = baseDrop;
        this.triviaKey = triviaKey;
        this.fabDrops = fabDrops;
        this.tierData = tierData;
        this.dataPerKill = dataPerKill;
    }

    public DataModel(DataModel other, List<ItemStack> newResults) {
        this.type = other.type;
        this.subtypes = other.subtypes;
        this.name = other.name;
        this.displayNbt = other.displayNbt;
        this.guiScale = other.guiScale;
        this.guiYOff = other.guiYOff;
        this.guiXOff = other.guiXOff;
        this.guiZOff = other.guiZOff;
        this.simCost = other.simCost;
        this.input = other.input;
        this.baseDrop = other.baseDrop;
        this.triviaKey = other.triviaKey;
        this.fabDrops = newResults;
        this.tierData = other.tierData;
        this.dataPerKill = other.dataPerKill;
    }

    public PSerializer<DataModel> getSerializer() {
        return SERIALIZER;
    }

    public MutableComponent getName() {
        return this.name;
    }

    public String getTriviaKey() {
        return this.triviaKey;
    }

    public float getScale() {
        return this.guiScale;
    }

    public float getYOffset() {
        return this.guiYOff;
    }

    public float getXOffset() {
        return this.guiXOff;
    }

    public float getZOffset() {
        return this.guiZOff;
    }

    public int getSimCost() {
        return this.simCost;
    }

    public EntityType<? extends LivingEntity> getType() {
        return this.type;
    }

    public List<EntityType<? extends LivingEntity>> getSubtypes() {
        return this.subtypes;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getBaseDrop() {
        return this.baseDrop;
    }

    public List<ItemStack> getFabDrops() {
        return this.fabDrops;
    }

    public int getTierData(ModelTier tier) {
        return this.tierData[tier.ordinal()];
    }

    public int getDataPerKill(ModelTier tier) {
        return this.dataPerKill[tier.ordinal()];
    }

    public ItemStack getPredictionDrop() {
        ItemStack stk = new ItemStack((ItemLike)Hostile.Items.PREDICTION.get());
        MobPredictionItem.setStoredModel(stk, this);
        return stk;
    }

    public int getNameColor() {
        return this.name.m_7383_().m_131135_().m_131265_();
    }

    public CompoundTag getDisplayNbt() {
        return this.displayNbt;
    }

    public boolean equals(Object obj) {
        return obj instanceof DataModel && ((DataModel)((Object)obj)).id.equals((Object)this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.format("DataModel[%s]", this.id);
    }

    public DataModel validate() {
        Preconditions.checkNotNull(this.type, (Object)"Invalid entity type!");
        Preconditions.checkNotNull((Object)this.name, (Object)"Invalid entity name!");
        Preconditions.checkArgument((this.guiScale > 0.0f ? 1 : 0) != 0, (Object)"Invalid gui scale!");
        Preconditions.checkArgument((this.simCost > 0 ? 1 : 0) != 0, (Object)"Invalid simulation cost!");
        Preconditions.checkArgument((this.input != null && !this.input.m_41619_() ? 1 : 0) != 0, (Object)"Invalid input item!");
        Preconditions.checkNotNull((Object)this.baseDrop, (Object)"Invalid base drop!");
        Preconditions.checkNotNull((Object)this.triviaKey, (Object)"Invalid trivia key!");
        Preconditions.checkNotNull(this.fabDrops, (Object)"Missing fabricator drops!");
        this.fabDrops.forEach(t -> Preconditions.checkArgument((t != null && !t.m_41619_() ? 1 : 0) != 0, (Object)"Invalid fabricator drop!"));
        Preconditions.checkArgument((this.tierData != null && this.tierData.length == 5 ? 1 : 0) != 0, (Object)"Invalid tier data!");
        Preconditions.checkArgument((this.dataPerKill != null && this.dataPerKill.length == 5 ? 1 : 0) != 0, (Object)"Invalid data per kill!");
        for (int i = 0; i < 4; ++i) {
            if (this.dataPerKill[i] <= 0) {
                throw new IllegalArgumentException("Data per kill may not be zero or negative!");
            }
            if (this.tierData[i] < this.tierData[i + 1]) continue;
            throw new IllegalArgumentException("Malformed tier data, all values must be ascending!");
        }
        return this;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(DataModel.getId(this.type));
        buf.writeByte(this.subtypes.size());
        for (EntityType<? extends LivingEntity> t : this.subtypes) {
            buf.m_130130_(DataModel.getId(t));
        }
        buf.m_130070_(((TranslatableContents)this.name.m_214077_()).m_237508_());
        buf.m_130070_(this.name.m_7383_().m_131135_().m_131274_());
        buf.m_130079_(this.displayNbt);
        buf.writeFloat(this.guiScale);
        buf.writeFloat(this.guiXOff);
        buf.writeFloat(this.guiYOff);
        buf.writeFloat(this.guiZOff);
        buf.writeInt(this.simCost);
        buf.m_130055_(this.input);
        buf.m_130055_(this.baseDrop);
        buf.m_130070_(this.triviaKey);
        buf.m_130130_(this.fabDrops.size());
        for (ItemStack i : this.fabDrops) {
            buf.m_130055_(i);
        }
        for (int i = 0; i < 5; ++i) {
            buf.writeShort(this.tierData[i]);
            buf.writeShort(this.dataPerKill[i]);
        }
    }

    private static int getId(EntityType<?> type) {
        return ((ForgeRegistry)ForgeRegistries.ENTITY_TYPES).getID(type);
    }

    private static EntityType<? extends LivingEntity> byId(int id) {
        return (EntityType)((ForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(id);
    }

    public static DataModel read(FriendlyByteBuf buf) {
        EntityType<? extends LivingEntity> type = DataModel.byId(buf.m_130242_());
        int size = buf.readByte();
        ArrayList<EntityType<? extends LivingEntity>> subtypes = new ArrayList<EntityType<? extends LivingEntity>>(size);
        for (int i = 0; i < size; ++i) {
            subtypes.add(DataModel.byId(buf.m_130242_()));
        }
        MutableComponent name = Component.m_237115_((String)buf.m_130277_());
        name.m_130948_(Style.f_131099_.m_131148_(TextColor.m_131268_((String)buf.m_130277_())));
        CompoundTag displayNbt = buf.m_130260_();
        float guiScale = buf.readFloat();
        float guiXOff = buf.readFloat();
        float guiYOff = buf.readFloat();
        float guiZOff = buf.readFloat();
        int simCost = buf.readInt();
        ItemStack input = buf.m_130267_();
        ItemStack baseDrop = buf.m_130267_();
        String triviaKey = buf.m_130277_();
        int dropSize = buf.m_130242_();
        ArrayList<ItemStack> fabDrops = new ArrayList<ItemStack>(dropSize);
        for (int i = 0; i < dropSize; ++i) {
            fabDrops.add(buf.m_130267_());
        }
        int[] tierData = new int[5];
        int[] dataPerKill = new int[5];
        for (int i = 0; i < 5; ++i) {
            tierData[i] = buf.readShort();
            dataPerKill[i] = buf.readShort();
        }
        DataModel model = new DataModel(type, subtypes, name, displayNbt, guiScale, guiXOff, guiYOff, guiZOff, simCost, input, baseDrop, triviaKey, fabDrops, tierData, dataPerKill);
        return model;
    }

    public JsonObject write() {
        JsonObject obj = new JsonObject();
        ResourceLocation key = EntityType.m_20613_(this.type);
        obj.addProperty("type", key.toString());
        obj.add("subtypes", ItemAdapter.ITEM_READER.toJsonTree(this.subtypes.stream().map(EntityType::m_20613_).toList()));
        obj.addProperty("name", ((TranslatableContents)this.name.m_214077_()).m_237508_());
        obj.addProperty("name_color", "0x" + Integer.toHexString(this.getNameColor()).toUpperCase(Locale.ROOT));
        obj.add("display_nbt", (JsonElement)NBTAdapter.EITHER_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.displayNbt).get().left().get());
        obj.addProperty("gui_scale", (Number)Float.valueOf(this.guiScale));
        obj.addProperty("gui_x_offset", (Number)Float.valueOf(this.guiXOff));
        obj.addProperty("gui_y_offset", (Number)Float.valueOf(this.guiYOff));
        obj.addProperty("gui_z_offset", (Number)Float.valueOf(this.guiZOff));
        obj.addProperty("sim_cost", (Number)this.simCost);
        obj.add("input", ItemAdapter.ITEM_READER.toJsonTree((Object)this.input));
        obj.add("base_drop", ItemAdapter.ITEM_READER.toJsonTree((Object)this.baseDrop));
        obj.addProperty("trivia", this.triviaKey);
        JsonArray fabDrops = ItemAdapter.ITEM_READER.toJsonTree(this.fabDrops).getAsJsonArray();
        for (JsonElement e : fabDrops) {
            JsonObject drop = e.getAsJsonObject();
            ResourceLocation itemName = new ResourceLocation(drop.get("item").getAsString());
            if ("minecraft".equals(itemName.m_135827_()) || key.m_135827_().equals(itemName.m_135827_())) continue;
            drop.addProperty("optional", Boolean.valueOf(true));
        }
        obj.add("fabricator_drops", (JsonElement)fabDrops);
        obj.add("tier_data", ItemAdapter.ITEM_READER.toJsonTree((Object)Arrays.copyOfRange(this.tierData, 1, 5)));
        obj.add("data_per_kill", ItemAdapter.ITEM_READER.toJsonTree((Object)Arrays.copyOfRange(this.dataPerKill, 0, 4)));
        return obj;
    }

    public static DataModel read(JsonObject obj) {
        EntityType t = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(obj.get("type").getAsString()));
        if (t == EntityType.f_20510_ && !"minecraft:pig".equals(obj.get("type").getAsString())) {
            throw new JsonParseException("DataModel has invalid entity type " + obj.get("type").getAsString());
        }
        ArrayList<EntityType<? extends LivingEntity>> subtypes = new ArrayList<EntityType<? extends LivingEntity>>();
        if (obj.has("subtypes")) {
            for (JsonElement json : obj.get("subtypes").getAsJsonArray()) {
                EntityType st = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(json.getAsString()));
                if (st == EntityType.f_20510_ && !"minecraft:pig".equals(json.getAsString())) continue;
                subtypes.add(st);
            }
        }
        MutableComponent name = Component.m_237115_((String)obj.get("name").getAsString());
        if (obj.has("name_color")) {
            String str;
            JsonPrimitive colorJson = obj.get("name_color").getAsJsonPrimitive();
            TextColor color = colorJson.isNumber() ? TextColor.m_131266_((int)colorJson.getAsInt()) : ((str = colorJson.getAsString()).startsWith("0x") ? TextColor.m_131266_((int)Integer.decode(str)) : TextColor.m_131268_((String)str));
            name = name.m_130948_(Style.f_131099_.m_131148_(color));
        } else {
            name.m_130948_(Style.f_131099_.m_131140_(ChatFormatting.WHITE));
        }
        float guiScale = obj.get("gui_scale").getAsFloat();
        float guiXOff = obj.get("gui_x_offset").getAsFloat();
        float guiYOff = obj.get("gui_y_offset").getAsFloat();
        float guiZOff = obj.get("gui_z_offset").getAsFloat();
        int simCost = obj.get("sim_cost").getAsInt();
        ItemStack input = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("input"), ItemStack.class);
        ItemStack baseDrop = (ItemStack)ItemAdapter.ITEM_READER.fromJson(obj.get("base_drop"), ItemStack.class);
        if (baseDrop.m_41619_()) {
            baseDrop = new ItemStack((ItemLike)Items.f_42127_);
            baseDrop.m_41714_((Component)Component.m_237115_((String)"hostilenetworks.info.no_base_drop"));
        }
        String triviaKey = obj.has("trivia") ? obj.get("trivia").getAsString() : "hostilenetworks.trivia.nothing";
        List fabDrops = (List)ItemAdapter.ITEM_READER.fromJson(obj.get("fabricator_drops"), new TypeToken<List<ItemStack>>(){}.getType());
        fabDrops.removeIf(ItemStack::m_41619_);
        int[] tierData = ModelTier.defaultData();
        if (obj.has("tier_data")) {
            JsonArray arr = obj.get("tier_data").getAsJsonArray();
            tierData = Stream.of(new JsonPrimitive((Number)0), arr.get(0), arr.get(1), arr.get(2), arr.get(3)).mapToInt(JsonElement::getAsShort).toArray();
        }
        int[] dataPerKill = ModelTier.defaultDataPerKill();
        if (obj.has("data_per_kill")) {
            JsonArray arr = obj.get("data_per_kill").getAsJsonArray();
            dataPerKill = Stream.of(arr.get(0), arr.get(1), arr.get(2), arr.get(3), new JsonPrimitive((Number)0)).mapToInt(JsonElement::getAsShort).toArray();
        }
        CompoundTag displayNbt = new CompoundTag();
        if (obj.has("display_nbt")) {
            displayNbt = (CompoundTag)((Pair)NBTAdapter.EITHER_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("display_nbt")).result().get()).getFirst();
        }
        return new DataModel((EntityType<? extends LivingEntity>)t, subtypes, name, displayNbt, guiScale, guiXOff, guiYOff, guiZOff, simCost, input, baseDrop, triviaKey, fabDrops, tierData, dataPerKill).validate();
    }
}

