/*
 * Decompiled with CFR 0.152.
 */
package shadows.hostilenetworks.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import shadows.hostilenetworks.HostileConfig;
import shadows.hostilenetworks.data.DataModel;
import shadows.hostilenetworks.gui.LootFabContainer;
import shadows.hostilenetworks.item.MobPredictionItem;
import shadows.placebo.screen.PlaceboContainerScreen;

public class LootFabScreen
extends PlaceboContainerScreen<LootFabContainer> {
    private static final int WIDTH = 176;
    private static final int HEIGHT = 178;
    private static final ResourceLocation BASE = new ResourceLocation("hostilenetworks", "textures/gui/loot_fabricator.png");
    private static final ResourceLocation PLAYER = new ResourceLocation("hostilenetworks", "textures/gui/default_gui.png");
    private DataModel model = null;
    private int currentPage = 0;
    private ImageButton btnLeft;
    private ImageButton btnRight;

    public LootFabScreen(LootFabContainer pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97727_ = 178;
        this.f_97726_ = 176;
    }

    public void m_6305_(PoseStack stack, int pMouseX, int pMouseY, float pPartialTicks) {
        this.model = MobPredictionItem.getStoredModel(((LootFabContainer)this.f_97732_).m_38853_(0).m_7993_());
        if (this.model != null) {
            this.btnLeft.f_93624_ = this.currentPage > 0;
            this.btnRight.f_93624_ = this.currentPage < this.model.getFabDrops().size() / 9;
        } else {
            this.btnLeft.f_93624_ = false;
            this.btnRight.f_93624_ = false;
        }
        super.m_6305_(stack, pMouseX, pMouseY, pPartialTicks);
    }

    public void m_7856_() {
        super.m_7856_();
        this.btnLeft = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.getGuiLeft() + 13, this.getGuiTop() + 68, 29, 12, 49, 83, 12, BASE, btn -> {
            if (this.model != null && this.currentPage > 0) {
                --this.currentPage;
            }
        }));
        this.btnRight = (ImageButton)this.m_142416_((GuiEventListener)new ImageButton(this.getGuiLeft() + 46, this.getGuiTop() + 68, 29, 12, 78, 83, 12, BASE, btn -> {
            if (this.model != null && this.currentPage < this.model.getFabDrops().size() / 9) {
                ++this.currentPage;
            }
        }));
    }

    protected void m_7027_(PoseStack pMatrixStack, int pX, int pY) {
    }

    protected void m_7025_(PoseStack pPoseStack, int pX, int pY) {
        int selection = ((LootFabContainer)this.f_97732_).getSelectedDrop(this.model);
        if (selection != -1 && this.m_6774_(79, 5, 16, 16, pX, pY)) {
            this.renderComponentTooltip(pPoseStack, Arrays.asList(Component.m_237115_((String)"hostilenetworks.gui.clear")), pX, pY, this.f_96547_);
        } else if (this.m_6774_(6, 10, 7, 53, pX, pY)) {
            ArrayList<MutableComponent> txt = new ArrayList<MutableComponent>(2);
            txt.add(Component.m_237110_((String)"hostilenetworks.gui.energy", (Object[])new Object[]{((LootFabContainer)this.f_97732_).getEnergyStored(), HostileConfig.fabPowerCap}));
            txt.add(Component.m_237110_((String)"hostilenetworks.gui.fab_cost", (Object[])new Object[]{HostileConfig.fabPowerCost}));
            this.renderComponentTooltip(pPoseStack, txt, pX, pY, this.f_96547_);
        }
        if (this.model != null) {
            List<ItemStack> drops = this.model.getFabDrops();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (y * 3 + x >= Math.min(drops.size() - this.currentPage * 9, 9) || !this.m_6774_(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY)) continue;
                    this.drawOnLeft(pPoseStack, this.m_96555_(drops.get(this.currentPage * 9 + y * 3 + x)), this.getGuiTop() + 15);
                }
            }
        }
        super.m_7025_(pPoseStack, pX, pY);
    }

    public boolean m_6375_(double pX, double pY, int pButton) {
        if (this.model != null) {
            List<ItemStack> drops = this.model.getFabDrops();
            int selection = ((LootFabContainer)this.f_97732_).getSelectedDrop(this.model);
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (y * 3 + x >= drops.size() || !this.m_6774_(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY) || selection == y * 3 + x) continue;
                    Minecraft.m_91087_().f_91072_.m_105208_(((LootFabContainer)this.f_97732_).f_38840_, this.currentPage * 9 + y * 3 + x);
                    Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                }
            }
            if (selection != -1 && this.m_6774_(79, 5, 16, 16, pX, pY)) {
                Minecraft.m_91087_().f_91072_.m_105208_(((LootFabContainer)this.f_97732_).f_38840_, -1);
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            }
        }
        return super.m_6375_(pX, pY, pButton);
    }

    protected void m_7286_(PoseStack stack, float pPartialTicks, int pX, int pY) {
        int selection;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BASE);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        GuiComponent.m_93133_((PoseStack)stack, (int)left, (int)top, (float)0.0f, (float)0.0f, (int)176, (int)83, (int)256, (int)256);
        int energyHeight = 53 - Mth.m_14167_((float)(53.0f * (float)((LootFabContainer)this.f_97732_).getEnergyStored() / (float)HostileConfig.fabPowerCap));
        GuiComponent.m_93133_((PoseStack)stack, (int)(left + 6), (int)(top + 10), (float)0.0f, (float)83.0f, (int)7, (int)energyHeight, (int)256, (int)256);
        int progHeight = Mth.m_14143_((float)(35.0f * ((float)((LootFabContainer)this.f_97732_).getRuntime() - pPartialTicks) / 60.0f));
        if (((LootFabContainer)this.f_97732_).getRuntime() == 0) {
            progHeight = 35;
        }
        GuiComponent.m_93133_((PoseStack)stack, (int)(left + 84), (int)(top + 23), (float)7.0f, (float)83.0f, (int)6, (int)progHeight, (int)256, (int)256);
        if (this.model != null) {
            List<ItemStack> drops = this.model.getFabDrops();
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    if (y * 3 + x >= Math.min(drops.size() - this.currentPage * 9, 9) || !this.m_6774_(18 + 18 * x, 10 + 18 * y, 16, 16, pX, pY)) continue;
                    GuiComponent.m_93133_((PoseStack)stack, (int)(left + 16 + 19 * x), (int)(top + 8 + 19 * y), (float)13.0f, (float)83.0f, (int)18, (int)18, (int)256, (int)256);
                }
            }
        }
        if ((selection = ((LootFabContainer)this.f_97732_).getSelectedDrop(this.model)) != -1 && selection / 9 == this.currentPage) {
            int selIdx = selection - this.currentPage * 9;
            GuiComponent.m_93133_((PoseStack)stack, (int)(left + 16 + 19 * (selIdx % 3)), (int)(top + 8 + 19 * (selIdx / 3)), (float)31.0f, (float)83.0f, (int)18, (int)18, (int)256, (int)256);
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)PLAYER);
        GuiComponent.m_93133_((PoseStack)stack, (int)left, (int)(top + 88), (float)0.0f, (float)0.0f, (int)176, (int)90, (int)256, (int)256);
        Minecraft mc = Minecraft.m_91087_();
        if (selection != -1) {
            List<ItemStack> drops = this.model.getFabDrops();
            mc.m_91291_().m_115203_(drops.get(selection), left + 79, top + 5);
            mc.m_91291_().m_115169_(this.f_96547_, drops.get(selection), left + 79 - 1, top + 5 - 1);
        }
        if (this.model != null) {
            left += 17;
            top += 9;
            List<ItemStack> drops = this.model.getFabDrops();
            int x = 0;
            int y = 0;
            for (int i = 0; i < Math.min(drops.size() - this.currentPage * 9, 9); ++i) {
                mc.m_91291_().m_115203_(drops.get(i + this.currentPage * 9), left + x * 19, top + y * 19);
                mc.m_91291_().m_115169_(this.f_96547_, drops.get(i + this.currentPage * 9), left + x * 19 - 1, top + y * 19 - 1);
                if (++x != 3) continue;
                ++y;
                x = 0;
            }
        }
    }

    public void drawOnLeft(PoseStack stack, List<Component> list, int y) {
        if (list.isEmpty()) {
            return;
        }
        int xPos = this.getGuiLeft() - 16 - list.stream().map(arg_0 -> ((Font)this.f_96547_).m_92852_(arg_0)).max(Integer::compare).get();
        int maxWidth = 9999;
        if (xPos < 0) {
            maxWidth = this.getGuiLeft() - 6;
            xPos = -8;
        }
        ArrayList split = new ArrayList();
        int lambdastupid = maxWidth;
        list.forEach(comp -> split.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)comp, lambdastupid, comp.m_7383_())));
        this.renderComponentTooltip(stack, split, xPos, y, this.f_96547_);
    }
}

