/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.yungsapi.YungsApiCommon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ItemRandomizer {
    public static final Codec<ItemRandomizer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Entry.CODEC.listOf().fieldOf("entries").forGetter(randomizer -> randomizer.entries), (App)Registry.f_122827_.m_194605_().fieldOf("defaultItem").forGetter(randomizer -> randomizer.defaultItem)).apply((Applicative)instance, ItemRandomizer::new));
    private List<Entry> entries = new ArrayList<Entry>();
    private Item defaultItem = Items.f_41852_;

    public CompoundTag saveTag() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_("defaultItemId", Registry.f_122827_.m_7447_((Object)this.defaultItem));
        ListTag entriesTag = (ListTag)Util.m_137469_((Object)new ListTag(), tag -> this.entries.forEach(entry -> {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128405_("entryItemId", Registry.f_122827_.m_7447_((Object)entry.item));
            entryTag.m_128350_("entryChance", entry.probability);
            tag.add((Object)entryTag);
        }));
        compoundTag.m_128365_("entries", (Tag)entriesTag);
        return compoundTag;
    }

    public ItemRandomizer(CompoundTag compoundTag) {
        this.defaultItem = (Item)Registry.f_122827_.m_7942_(compoundTag.m_128451_("defaultItemId"));
        this.entries = new ArrayList<Entry>();
        ListTag entriesTag = compoundTag.m_128437_("entries", 10);
        entriesTag.forEach(entryTag -> {
            CompoundTag entryCompoundTag = (CompoundTag)entryTag;
            Item item = (Item)Registry.f_122827_.m_7942_(entryCompoundTag.m_128451_("entryItemId"));
            float chance = entryCompoundTag.m_128457_("entryChance");
            this.addItem(item, chance);
        });
    }

    public ItemRandomizer(List<Entry> entries, Item defaultItem) {
        this.entries = entries;
        this.defaultItem = defaultItem;
    }

    public ItemRandomizer(Item defaultItem) {
        this.defaultItem = defaultItem;
    }

    public ItemRandomizer() {
    }

    public static ItemRandomizer from(Item ... items) {
        ItemRandomizer selector = new ItemRandomizer();
        float chance = 1.0f / (float)items.length;
        for (Item item : items) {
            selector.addItem(item, chance);
        }
        return selector;
    }

    public ItemRandomizer addItem(Item item, float chance) {
        if (this.entries.stream().anyMatch(entry -> entry.item.equals(item))) {
            YungsApiCommon.LOGGER.warn("WARNING: duplicate item {} added to ItemSetSelector!", (Object)item.toString());
            return this;
        }
        float currTotal = this.entries.stream().map(entry -> Float.valueOf(entry.probability)).reduce(Float::sum).orElse(Float.valueOf(0.0f)).floatValue();
        float newTotal = currTotal + chance;
        if (newTotal > 1.0f) {
            YungsApiCommon.LOGGER.warn("WARNING: item {} added to ItemSetSelector exceeds max probabiltiy of 1!", (Object)item.toString());
            return this;
        }
        this.entries.add(new Entry(item, chance));
        return this;
    }

    public Item get(Random random) {
        float target = random.nextFloat();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.item;
            }
            currBottom += entry.probability;
        }
        return this.defaultItem;
    }

    public Item get(RandomSource randomSource) {
        float target = randomSource.m_188501_();
        float currBottom = 0.0f;
        for (Entry entry : this.entries) {
            if (currBottom <= target && target < currBottom + entry.probability) {
                return entry.item;
            }
            currBottom += entry.probability;
        }
        return this.defaultItem;
    }

    public void setDefaultItem(Item item) {
        this.defaultItem = item;
    }

    public Map<Item, Float> getEntriesAsMap() {
        HashMap<Item, Float> map = new HashMap<Item, Float>();
        this.entries.forEach(entry -> map.put(entry.item, Float.valueOf(entry.probability)));
        return map;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Item getDefaultItem() {
        return this.defaultItem;
    }

    public static class Entry {
        public static Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122827_.m_194605_().fieldOf("item").forGetter(entry -> entry.item), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(entry -> Float.valueOf(entry.probability))).apply((Applicative)instance, Entry::new));
        public Item item;
        public float probability;

        public Entry(Item item, float probability) {
            this.item = item;
            this.probability = probability;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.item.equals(((Entry)obj).item);
            }
            if (obj instanceof Item) {
                return this.item.equals(obj);
            }
            return false;
        }
    }
}

