/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.client.IChargingStationRenderOverride;
import me.desht.pneumaticcraft.api.client.IClientRegistry;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.assembly_machine.IAssemblyRenderOverriding;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ClientRegistryImpl
implements IClientRegistry {
    private static final ClientRegistryImpl INSTANCE = new ClientRegistryImpl();
    private static final Map<Item, IAssemblyRenderOverriding> renderOverrides = new ConcurrentHashMap<Item, IAssemblyRenderOverriding>();
    private static final Map<Item, IChargingStationRenderOverride> chargingRenderOverrides = new ConcurrentHashMap<Item, IChargingStationRenderOverride>();
    private static final IChargingStationRenderOverride DEFAULT_CHARGING_RENDERER = (poseStack, renderedStack, partialTicks, bufferIn, combinedLightIn, combinedOverlayIn) -> true;

    private ClientRegistryImpl() {
    }

    public static ClientRegistryImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat(Screen gui, int backgroundColor) {
        return new WidgetAnimatedStat(gui, backgroundColor);
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat(Screen gui, ItemStack iconStack, int backgroundColor) {
        return new WidgetAnimatedStat(gui, backgroundColor, iconStack);
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat(Screen gui, ResourceLocation iconTexture, int backgroundColor) {
        return new WidgetAnimatedStat(gui, backgroundColor, iconTexture);
    }

    @Override
    public void drawPressureGauge(PoseStack matrixStack, Font fontRenderer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, fontRenderer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, 0);
    }

    @Override
    public void registerRenderOverride(@Nonnull ItemLike entry, @Nonnull IAssemblyRenderOverriding renderOverride) {
        renderOverrides.put(entry.m_5456_(), renderOverride);
    }

    public IAssemblyRenderOverriding getAssemblyRenderOverride(ItemLike entry) {
        return renderOverrides.get(entry.m_5456_());
    }

    @Override
    public void registerRenderOverride(@NotNull ItemLike item, @NotNull IChargingStationRenderOverride renderOverride) {
        chargingRenderOverrides.put(item.m_5456_(), renderOverride);
    }

    @Nonnull
    public IChargingStationRenderOverride getChargingRenderOverride(ItemLike item) {
        return chargingRenderOverrides.getOrDefault(item.m_5456_(), DEFAULT_CHARGING_RENDERER);
    }
}

