/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.mojang.blaze3d.platform.InputConstants;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IKeybindingButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.settings.KeyModifier;

public class KeybindingButton
extends WidgetButtonExtended
implements IKeybindingButton {
    private final KeyMapping keyBinding;
    private final Component origButtonText;
    private boolean bindingMode = false;
    private boolean modifier = false;
    private Action action = Action.NONE;

    public KeybindingButton(int startX, int startY, int xSize, int ySize, Component buttonText, KeyMapping keyBinding) {
        super(startX, startY, xSize, ySize, buttonText);
        this.keyBinding = keyBinding;
        this.origButtonText = buttonText;
        this.addTooltip();
    }

    private void addTooltip() {
        this.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindBoundKey", ClientUtils.translateKeyBind(this.keyBinding)));
    }

    @Override
    public void m_5691_() {
        if (this.bindingMode) {
            if (!this.modifier) {
                this.setBindingMode(false);
            }
        } else {
            this.setBindingMode(true);
        }
    }

    private void setBindingMode(boolean newMode) {
        this.bindingMode = newMode;
        if (this.bindingMode) {
            this.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.setKeybind", new Object[0]).m_130940_(ChatFormatting.YELLOW));
            this.setTooltipText((Component)Component.m_237119_());
        } else {
            this.m_93666_(this.origButtonText);
            this.addTooltip();
            switch (this.action) {
                case ADD: {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12211_, 1.0f, 1.0f);
                    break;
                }
                case REMOVE: {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11983_, 1.0f, 1.0f);
                }
            }
            this.action = Action.NONE;
        }
    }

    @Override
    public boolean receiveKey(InputConstants.Type type, int keyCode) {
        if (this.bindingMode) {
            if (type == InputConstants.Type.KEYSYM && keyCode == 256) {
                this.keyBinding.setKeyModifierAndCode(KeyModifier.NONE, InputConstants.f_84822_);
                Minecraft.m_91087_().f_91066_.m_92159_(this.keyBinding, InputConstants.f_84822_);
                this.action = Action.REMOVE;
            } else {
                InputConstants.Key input = type.m_84895_(keyCode);
                this.modifier = KeyModifier.isKeyCodeModifier((InputConstants.Key)input);
                this.keyBinding.setKeyModifierAndCode(KeyModifier.getActiveModifier(), input);
                Minecraft.m_91087_().f_91066_.m_92159_(this.keyBinding, input);
                this.action = Action.ADD;
            }
            KeyMapping.m_90854_();
            this.m_5691_();
            return true;
        }
        return false;
    }

    @Override
    public void receiveKeyReleased() {
        this.setBindingMode(false);
    }

    private static enum Action {
        NONE,
        ADD,
        REMOVE;

    }
}

